/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Objects;
import com.google.javascript.jscomp.deps.DependencyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SimpleDependencyInfo
implements DependencyInfo {
    private final List<String> provides;
    private final List<String> requires;
    private final String srcPathRelativeToClosure;
    private final String pathOfDefiningFile;

    public SimpleDependencyInfo(String string, String string2, List<String> list, List<String> list2) {
        this.srcPathRelativeToClosure = string;
        this.pathOfDefiningFile = string2;
        this.provides = list;
        this.requires = list2;
    }

    @Override
    public String getName() {
        return this.pathOfDefiningFile;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.srcPathRelativeToClosure;
    }

    @Override
    public Collection<String> getProvides() {
        return Collections.unmodifiableList(this.provides);
    }

    @Override
    public Collection<String> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleDependencyInfo)) {
            return false;
        }
        SimpleDependencyInfo simpleDependencyInfo = (SimpleDependencyInfo)object;
        return Objects.equal((Object)simpleDependencyInfo.srcPathRelativeToClosure, (Object)this.srcPathRelativeToClosure) && Objects.equal((Object)simpleDependencyInfo.pathOfDefiningFile, (Object)this.pathOfDefiningFile) && Objects.equal(simpleDependencyInfo.requires, this.requires) && Objects.equal(simpleDependencyInfo.provides, this.provides);
    }

    public String toString() {
        return String.format("DependencyInfo(relativePath='%1$s', path='%2$s', provides=%3$s, requires=%4$s)", this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.provides, this.requires);
    }
}

