/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;

public abstract class SourceFile {
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private String originalPath = null;
    private int lastOffset;
    private int lastLine;
    private String code = null;

    SourceFile(String string) {
        this.fileName = string;
        this.lastOffset = 0;
        this.lastLine = 1;
    }

    public String getCode() throws IOException {
        return this.code;
    }

    public Reader getCodeReader() throws IOException {
        return new StringReader(this.getCode());
    }

    @VisibleForTesting
    String getCodeNoCache() {
        return this.code;
    }

    private void setCode(String string) {
        this.code = string;
    }

    public String getOriginalPath() {
        return this.originalPath != null ? this.originalPath : this.fileName;
    }

    public void setOriginalPath(String string) {
        this.originalPath = string;
    }

    public void clearCachedSource() {
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    public String getName() {
        return this.fileName;
    }

    public String getLine(int n) {
        String string = "";
        try {
            string = this.getCode();
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = 0;
        int n3 = 1;
        if (n >= this.lastLine) {
            n2 = this.lastOffset;
            n3 = this.lastLine;
        }
        for (int i = n3; i < n; ++i) {
            int n4 = string.indexOf(10, n2);
            if (n4 == -1) {
                return null;
            }
            n2 = n4 + 1;
        }
        this.lastOffset = n2;
        this.lastLine = n;
        return string.indexOf(10, n2) == -1 ? null : string.substring(n2, string.indexOf(10, n2));
    }

    public Region getRegion(int n) {
        int n2;
        int n3;
        String string = "";
        try {
            string = this.getCode();
        }
        catch (IOException iOException) {
            return null;
        }
        int n4 = 0;
        int n5 = Math.max(1, n - 3 + 1);
        for (n3 = 1; n3 < n5 && (n2 = string.indexOf(10, n4)) != -1; ++n3) {
            n4 = n2 + 1;
        }
        n3 = n4;
        n2 = n5;
        int n6 = 0;
        while (n6 < 5 && (n3 = string.indexOf(10, n3)) != -1) {
            ++n3;
            ++n6;
            ++n2;
        }
        if (n >= n2) {
            return null;
        }
        if (n3 == -1) {
            n6 = string.length() - 1;
            if (string.charAt(n6) == '\n') {
                return new SimpleRegion(n5, n2, string.substring(n4, n6));
            }
            return new SimpleRegion(n5, n2, string.substring(n4));
        }
        return new SimpleRegion(n5, n2, string.substring(n4, n3));
    }

    public String toString() {
        return this.fileName;
    }

    public static SourceFile fromFile(String string, Charset charset) {
        return SourceFile.fromFile(new File(string), charset);
    }

    public static SourceFile fromFile(String string) {
        return SourceFile.fromFile(new File(string));
    }

    public static SourceFile fromFile(File file, Charset charset) {
        return new OnDisk(file, charset);
    }

    public static SourceFile fromFile(File file) {
        return new OnDisk(file);
    }

    public static SourceFile fromCode(String string, String string2) {
        return new Preloaded(string, string2);
    }

    public static SourceFile fromCode(String string, String string2, String string3) {
        return new Preloaded(string, string2, string3);
    }

    public static SourceFile fromInputStream(String string, InputStream inputStream) throws IOException {
        return SourceFile.fromCode(string, CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8)));
    }

    public static SourceFile fromInputStream(String string, String string2, InputStream inputStream) throws IOException {
        return SourceFile.fromCode(string, string2, CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8)));
    }

    public static SourceFile fromReader(String string, Reader reader) throws IOException {
        return SourceFile.fromCode(string, CharStreams.toString((Readable)reader));
    }

    public static SourceFile fromGenerator(String string, Generator generator) {
        return new Generated(string, generator);
    }

    static class OnDisk
    extends SourceFile {
        private final File file;
        protected String inputCharset = Charsets.UTF_8.name();

        OnDisk(File file, Charset charset) {
            this(file);
            if (charset != null) {
                this.setCharset(charset);
            }
        }

        OnDisk(File file) {
            super(file.getPath());
            this.file = file;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String string = super.getCode();
            if (string == null) {
                string = Files.toString((File)this.file, (Charset)this.getCharset());
                ((SourceFile)this).setCode(string);
            }
            return string;
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return new FileReader(this.file);
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }

        public void setCharset(Charset charset) {
            this.inputCharset = charset.name();
        }

        public Charset getCharset() {
            return Charset.forName(this.inputCharset);
        }
    }

    static class Generated
    extends SourceFile {
        private final Generator generator;

        Generated(String string, Generator generator) {
            super(string);
            this.generator = generator;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String string = super.getCode();
            if (string == null) {
                string = this.generator.getCode();
                ((SourceFile)this).setCode(string);
            }
            return string;
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }
    }

    static class Preloaded
    extends SourceFile {
        Preloaded(String string, String string2) {
            this(string, string, string2);
        }

        Preloaded(String string, String string2, String string3) {
            super(string);
            super.setOriginalPath(string2);
            ((SourceFile)this).setCode(string3);
        }
    }

    public static interface Generator {
        public String getCode();
    }
}

