/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.Strings;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.rhino.Node;

class SanityCheck
implements CompilerPass {
    static final DiagnosticType CANNOT_PARSE_GENERATED_CODE = DiagnosticType.error("JSC_CANNOT_PARSE_GENERATED_CODE", "Internal compiler error. Cannot parse generated code: {0}");
    static final DiagnosticType GENERATED_BAD_CODE = DiagnosticType.error("JSC_GENERATED_BAD_CODE", "Internal compiler error. Generated bad code.----------------------------------------\nExpected:\n{0}\n----------------------------------------\nActual:\n{1}");
    private final AbstractCompiler compiler;

    SanityCheck(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.sanityCheckNormalization(node, node2);
        this.sanityCheckCodeGeneration(node2);
        this.sanityCheckVars(node, node2);
    }

    private void sanityCheckVars(Node node, Node node2) {
        if (this.compiler.isNormalized()) {
            new VarCheck(this.compiler, true).process(node, node2);
        }
    }

    private Node sanityCheckCodeGeneration(Node node) {
        if (this.compiler.hasHaltingErrors()) {
            return null;
        }
        String string = this.compiler.toSource(node);
        Node node2 = this.compiler.parseSyntheticCode(string);
        if (this.compiler.hasHaltingErrors()) {
            this.compiler.report(JSError.make(CANNOT_PARSE_GENERATED_CODE, Strings.truncateAtMaxLength(string, 100, true)));
            throw new IllegalStateException("Sanity Check failed");
        }
        String string2 = this.compiler.toSource(node2);
        if (!string.equals(string2)) {
            this.compiler.report(JSError.make(GENERATED_BAD_CODE, Strings.truncateAtMaxLength(string, 1000, true), Strings.truncateAtMaxLength(string2, 1000, true)));
            throw new IllegalStateException("Sanity Check failed");
        }
        return node2;
    }

    private void sanityCheckNormalization(Node node, Node node2) {
        CodeChangeHandler.ForbiddenChange forbiddenChange = new CodeChangeHandler.ForbiddenChange();
        this.compiler.addChangeHandler(forbiddenChange);
        new PrepareAst(this.compiler, true).process(null, node2);
        if (this.compiler.isNormalized()) {
            new Normalize(this.compiler, true).process(node, node2);
            boolean bl = true;
            Normalize.VerifyConstants verifyConstants = new Normalize.VerifyConstants(this.compiler, bl);
            verifyConstants.process(node, node2);
        }
        this.compiler.removeChangeHandler(forbiddenChange);
    }
}

