/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

public class PeepholeFoldWithTypes
extends AbstractPeepholeOptimization {
    @Override
    Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 32: {
                return this.tryFoldTypeof(node);
            }
        }
        return node;
    }

    private Node tryFoldTypeof(Node node) {
        Preconditions.checkArgument((node.getType() == 32 ? 1 : 0) != 0);
        Preconditions.checkArgument((node.getFirstChild() != null ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (!NodeUtil.isLiteralValue(node2, true) && !this.mayHaveSideEffects(node2)) {
            JSType jSType = node2.getJSType();
            String string = null;
            if (jSType != null) {
                if (jSType.isObject() || jSType.isNullType()) {
                    string = "object";
                } else if (jSType.isStringValueType()) {
                    string = "string";
                } else if (jSType.isNumberValueType()) {
                    string = "number";
                } else if (jSType.isBooleanValueType()) {
                    string = "boolean";
                } else if (jSType.isVoidType()) {
                    string = "undefined";
                } else if (jSType.isUnionType()) {
                    string = null;
                }
                if (string != null) {
                    Node node3 = Node.newString(string);
                    node.getParent().replaceChild(node, node3);
                    this.reportCodeChange();
                    return node3;
                }
            }
        }
        return node;
    }
}

