/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class NameReferenceGraphReport {
    private NameReferenceGraph graph = null;

    NameReferenceGraphReport(NameReferenceGraph nameReferenceGraph) {
        this.graph = nameReferenceGraph;
    }

    public String getHtmlReport() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList = Lists.newArrayList(this.graph.getDirectedGraphNodes());
        this.generateHtmlReportHeader(stringBuilder);
        stringBuilder.append("<h1>Name Reference Graph Dump</h1>\n");
        stringBuilder.append("OVERALL STATS\n");
        stringBuilder.append("<ul>\n");
        stringBuilder.append("<li>Total names: " + arrayList.size());
        stringBuilder.append("</ul>\n");
        stringBuilder.append("ALL NAMES\n");
        stringBuilder.append("<UL>\n");
        Collections.sort(arrayList, new DiGraphNodeComparator());
        for (DiGraph.DiGraphNode diGraphNode : arrayList) {
            this.generateDeclarationReport(stringBuilder, diGraphNode);
            List list = this.graph.getOutEdges(diGraphNode.getValue());
            List list2 = this.graph.getInEdges(diGraphNode.getValue());
            if (list.isEmpty() && list2.isEmpty()) continue;
            stringBuilder.append("<ul>");
            if (list.size() > 0) {
                stringBuilder.append("<li>REFERS TO:<br>\n");
                stringBuilder.append("<ul>");
                for (DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphEdge : list) {
                    this.generateEdgeReport(stringBuilder, (NameReferenceGraph.Name)diGraphEdge.getDestination().getValue(), diGraphEdge);
                }
                stringBuilder.append("</ul>\n");
            }
            if (list2.size() > 0) {
                stringBuilder.append("<li>REFERENCED BY:<br>\n");
                stringBuilder.append("<ul>");
                for (DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphEdge : list2) {
                    this.generateEdgeReport(stringBuilder, (NameReferenceGraph.Name)diGraphEdge.getSource().getValue(), diGraphEdge);
                }
                stringBuilder.append("</ul>");
            }
            stringBuilder.append("</ul>\n");
        }
        stringBuilder.append("</ul>\n");
        this.generateHtmlReportFooter(stringBuilder);
        return stringBuilder.toString();
    }

    private String getSourceFile(Node node) {
        String string = (String)node.getProp(16);
        if (string == null) {
            return "";
        }
        return string;
    }

    private void generateDeclarationReport(StringBuilder stringBuilder, DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphNode) {
        String string = ((NameReferenceGraph.Name)diGraphNode.getValue()).getQualifiedName();
        JSType jSType = ((NameReferenceGraph.Name)diGraphNode.getValue()).getType();
        stringBuilder.append("<LI> ");
        stringBuilder.append("<A NAME=\"" + string + "\">");
        stringBuilder.append(string);
        stringBuilder.append("\n");
        this.generateType(stringBuilder, jSType);
        List<DefinitionsRemover.Definition> list = ((NameReferenceGraph.Name)diGraphNode.getValue()).getDeclarations();
        if (list.size() == 0) {
            stringBuilder.append("<br>No definitions found<br>");
        } else {
            stringBuilder.append("<ul>");
            for (DefinitionsRemover.Definition definition : list) {
                Node node = definition.getRValue();
                String string2 = this.getSourceFile(node);
                stringBuilder.append("<li> Defined: ");
                this.generateSourceReferenceLink(stringBuilder, string2, node.getLineno(), node.getCharno());
            }
            stringBuilder.append("</ul>");
        }
    }

    private void generateHtmlReportHeader(StringBuilder stringBuilder) {
        stringBuilder.append("<!DOCTYPE html>\n<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" ><title>Name Reference Graph Dump</title><style type=\"text/css\">body, td, ");
        stringBuilder.append("p {font-family: Arial; font-size: 83%} ");
        stringBuilder.append("ul {margin-top:2px; margin-left:0px; padding-left:1em;}");
        stringBuilder.append("li {margin-top:3px; margin-left:24px;padding-left:0px;padding-bottom: 4px}");
        stringBuilder.append("</style></head><body>\n");
    }

    private void generateHtmlReportFooter(StringBuilder stringBuilder) {
        stringBuilder.append("</body></html>");
    }

    private void generateEdgeReport(StringBuilder stringBuilder, NameReferenceGraph.Name name, DiGraph.DiGraphEdge<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphEdge) {
        String string = name.getQualifiedName();
        stringBuilder.append("<li><A HREF=\"#" + string + "\">");
        stringBuilder.append(string);
        stringBuilder.append("</a> ");
        Node node = ((NameReferenceGraph.Reference)diGraphEdge.getValue()).getSite();
        int n = node.getLineno();
        int n2 = node.getCharno();
        String string2 = this.getSourceFile(node);
        this.generateSourceReferenceLink(stringBuilder, string2, n, n2);
        JSType jSType = ((NameReferenceGraph.Reference)diGraphEdge.getValue()).getSite().getJSType();
        this.generateType(stringBuilder, jSType);
    }

    private void generateSourceReferenceLink(StringBuilder stringBuilder, String string, int n, int n2) {
        assert (string != null);
        stringBuilder.append("(");
        stringBuilder.append(string + ":" + n + "," + n2);
        stringBuilder.append(")");
    }

    private void generateType(StringBuilder stringBuilder, JSType jSType) {
        if (jSType == null) {
            stringBuilder.append(" (type: null) ");
        } else if (jSType.isUnknownType()) {
            stringBuilder.append(" (type: unknown) ");
        } else {
            stringBuilder.append(" (type: " + jSType.toString() + ") ");
        }
    }

    class DiGraphNodeComparator
    implements Comparator<DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference>> {
        DiGraphNodeComparator() {
        }

        @Override
        public int compare(DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphNode, DiGraph.DiGraphNode<NameReferenceGraph.Name, NameReferenceGraph.Reference> diGraphNode2) {
            Preconditions.checkNotNull(diGraphNode.getValue());
            Preconditions.checkNotNull(diGraphNode2.getValue());
            if (((NameReferenceGraph.Name)diGraphNode.getValue()).getQualifiedName() == null && ((NameReferenceGraph.Name)diGraphNode2.getValue()).getQualifiedName() == null) {
                return 0;
            }
            if (((NameReferenceGraph.Name)diGraphNode.getValue()).getQualifiedName() == null) {
                return -1;
            }
            if (((NameReferenceGraph.Name)diGraphNode2.getValue()).getQualifiedName() == null) {
                return 1;
            }
            return ((NameReferenceGraph.Name)diGraphNode.getValue()).getQualifiedName().compareTo(((NameReferenceGraph.Name)diGraphNode2.getValue()).getQualifiedName());
        }
    }
}

