/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeNameExtractor;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.logging.Logger;

class NameAnonymousFunctions
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(NameAnonymousFunctions.class.getName());
    static final char DELIMITER = '$';
    private final AbstractCompiler compiler;
    private int namedCount = 0;
    private int bytesUsed = 0;

    NameAnonymousFunctions(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        AnonymousFunctionNamingCallback anonymousFunctionNamingCallback = new AnonymousFunctionNamingCallback(new AnonymousFunctionNamer());
        NodeTraversal.traverse(this.compiler, node2, anonymousFunctionNamingCallback);
        logger.info("Named " + this.namedCount + " anon functions using " + this.bytesUsed + " bytes");
    }

    private class AnonymousFunctionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private NodeNameExtractor nameExtractor = new NodeNameExtractor('$');

        AnonymousFunctionNamer() {
        }

        private String getLikelyNonConflictingName(String string) {
            return '$' + string + '$';
        }

        @Override
        public final String getName(Node node) {
            return this.nameExtractor.getName(node);
        }

        @Override
        public final void setFunctionName(String string, Node node) {
            Node node2 = node.getFirstChild();
            String string2 = this.getLikelyNonConflictingName(string);
            node2.setString(string2);
            NameAnonymousFunctions.this.compiler.reportCodeChange();
            NameAnonymousFunctions.this.namedCount++;
            NameAnonymousFunctions.this.bytesUsed += string2.length();
        }

        @Override
        public final String getCombinedName(String string, String string2) {
            return string + '$' + string2;
        }
    }
}

