/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MoveFunctionDeclarations
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<JSModule, List<Node>> functions;

    MoveFunctionDeclarations(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.functions = Maps.newHashMap();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
        for (Map.Entry<JSModule, List<Node>> entry : this.functions.entrySet()) {
            JSModule jSModule = entry.getKey();
            Node node3 = this.compiler.getNodeForCodeInsertion(jSModule);
            for (Node node4 : Lists.reverse(entry.getValue())) {
                node3.addChildToFront(node4);
            }
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3 = node.getAncestor(2);
        return node3 == null || node3.getType() != 132;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node2 == null || node2.getType() != 132) {
            return;
        }
        if (NodeUtil.isFunctionDeclaration(node)) {
            node2.removeChild(node);
            this.compiler.reportCodeChange();
            JSModule jSModule = nodeTraversal.getModule();
            ArrayList arrayList = this.functions.get(jSModule);
            if (arrayList == null) {
                arrayList = Lists.newArrayList();
                this.functions.put(jSModule, arrayList);
            }
            arrayList.add(node);
        }
    }
}

