/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.List;

class FunctionRewriter
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final int SAVINGS_THRESHOLD = 16;

    FunctionRewriter(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        ImmutableList immutableList = ImmutableList.of((Object)new ReturnConstantReducer(), (Object)new GetterReducer(), (Object)new SetterReducer(), (Object)new EmptyFunctionReducer(), (Object)new IdentityReducer());
        HashMultimap hashMultimap = HashMultimap.create();
        NodeTraversal.traverse(this.compiler, node2, new ReductionGatherer((List<Reducer>)immutableList, (Multimap<Reducer, Reduction>)hashMultimap));
        for (Reducer reducer : immutableList) {
            Node node3;
            Collection collection = hashMultimap.get((Object)reducer);
            if (collection.isEmpty() || (node3 = this.parseHelperCode(reducer)) == null) continue;
            int n = InlineCostEstimator.getCost(node3);
            int n2 = 0;
            for (Reduction reduction : collection) {
                n2 += reduction.estimateSavings();
            }
            if (n2 <= n + 16) continue;
            for (Reduction reduction : collection) {
                reduction.apply();
            }
            Node node4 = this.compiler.getNodeForCodeInsertion(null);
            node4.addChildrenToFront(node3);
            this.compiler.reportCodeChange();
        }
    }

    public Node parseHelperCode(Reducer reducer) {
        Node node = this.compiler.parseSyntheticCode(reducer.getClass().toString() + ":helper", reducer.getHelperSource());
        return node != null ? node.removeFirstChild() : null;
    }

    private static class SetterReducer
    extends Reducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_set";
        static final String HELPER_SOURCE = "function JSCompiler_set(JSCompiler_set_name) {  return function(JSCompiler_set_value) {this[JSCompiler_set_name] = JSCompiler_set_value}}";

        private SetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node node2 = this.getSetPropertyName(node);
            if (node2 != null) {
                if (node2.getType() != 40) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(node2.getType()));
                }
                return this.buildCallNode(FACTORY_METHOD_NAME, node2, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getSetPropertyName(Node node) {
            Node node2;
            Node node3 = node.getLastChild();
            if (!node3.hasOneChild()) {
                return null;
            }
            Node node4 = node.getFirstChild().getNext();
            Node node5 = node4.getFirstChild();
            if (node5 == null) {
                return null;
            }
            Node node6 = node3.getFirstChild();
            if (!NodeUtil.isExprAssign(node6)) {
                return null;
            }
            Node node7 = node6.getFirstChild();
            Node node8 = node7.getFirstChild();
            if (NodeUtil.isGetProp(node8) && NodeUtil.isThis(node8.getFirstChild()) && NodeUtil.isName(node2 = node7.getLastChild()) && node2.getString().equals(node5.getString())) {
                Node node9 = node8.getLastChild();
                return node9;
            }
            return null;
        }
    }

    private static class GetterReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_get";
        static final String HELPER_SOURCE = "function JSCompiler_get(JSCompiler_get_name) {  return function() {return this[JSCompiler_get_name]}}";

        private GetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node node2 = this.getGetPropertyName(node);
            if (node2 != null) {
                if (node2.getType() != 40) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(node2.getType()));
                }
                return this.buildCallNode(FACTORY_METHOD_NAME, node2, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getGetPropertyName(Node node) {
            Node node2 = this.maybeGetSingleReturnRValue(node);
            if (node2 != null && NodeUtil.isGetProp(node2) && NodeUtil.isThis(node2.getFirstChild())) {
                return node2.getLastChild();
            }
            return null;
        }
    }

    private static class ReturnConstantReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_returnArg";
        static final String HELPER_SOURCE = "function JSCompiler_returnArg(JSCompiler_returnArg_value) {  return function() {return JSCompiler_returnArg_value}}";

        private ReturnConstantReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node node2 = this.getValueNode(node);
            if (node2 != null) {
                return this.buildCallNode(FACTORY_METHOD_NAME, node2, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getValueNode(Node node) {
            Node node2 = this.maybeGetSingleReturnRValue(node);
            if (node2 != null && NodeUtil.isImmutableValue(node2)) {
                return node2;
            }
            return null;
        }
    }

    private static class IdentityReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_identityFn";
        static final String HELPER_SOURCE = "function JSCompiler_identityFn() {  return function(JSCompiler_identityFn_value) {return JSCompiler_identityFn_value}}";

        private IdentityReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            if (this.isIdentityFunction(node)) {
                return this.buildCallNode(FACTORY_METHOD_NAME, null, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private boolean isIdentityFunction(Node node) {
            Node node2 = node.getFirstChild().getNext();
            Node node3 = node2.getFirstChild();
            if (node3 == null) {
                return false;
            }
            Node node4 = this.maybeGetSingleReturnRValue(node);
            return node4 != null && NodeUtil.isName(node4) && node4.getString().equals(node3.getString());
        }
    }

    static abstract class SingleReturnStatementReducer
    extends Reducer {
        SingleReturnStatementReducer() {
        }

        protected final Node maybeGetSingleReturnRValue(Node node) {
            Node node2 = node.getLastChild();
            if (!node2.hasOneChild()) {
                return null;
            }
            Node node3 = node2.getFirstChild();
            if (node3.getType() == 4) {
                return node3.getFirstChild();
            }
            return null;
        }
    }

    private static class EmptyFunctionReducer
    extends Reducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_emptyFn";
        static final String HELPER_SOURCE = "function JSCompiler_emptyFn() {  return function() {}}";

        private EmptyFunctionReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (NodeUtil.isEmptyFunctionExpression(node)) {
                return this.buildCallNode(FACTORY_METHOD_NAME, null, node.getLineno(), node.getCharno());
            }
            return node;
        }
    }

    static abstract class Reducer {
        Reducer() {
        }

        abstract String getHelperSource();

        abstract Node reduce(Node var1);

        protected final Node buildCallNode(String string, Node node, int n, int n2) {
            Node node2 = new Node(37, n, n2);
            node2.addChildToBack(Node.newString(38, string));
            if (node != null) {
                node2.addChildToBack(node.cloneTree());
            }
            return node2;
        }
    }

    private class ReductionGatherer
    implements NodeTraversal.Callback {
        private final List<Reducer> reducers;
        private final Multimap<Reducer, Reduction> reductions;

        ReductionGatherer(List<Reducer> list, Multimap<Reducer, Reduction> multimap) {
            this.reducers = list;
            this.reductions = multimap;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            for (Reducer reducer : this.reducers) {
                Node node3 = reducer.reduce(node);
                if (node3 == node) continue;
                this.reductions.put((Object)reducer, (Object)new Reduction(node2, node, node3));
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }

    private class Reduction {
        private final Node parent;
        private final Node oldChild;
        private final Node newChild;

        Reduction(Node node, Node node2, Node node3) {
            this.parent = node;
            this.oldChild = node2;
            this.newChild = node3;
        }

        void apply() {
            this.parent.replaceChild(this.oldChild, this.newChild);
            FunctionRewriter.this.compiler.reportCodeChange();
        }

        int estimateSavings() {
            return InlineCostEstimator.getCost(this.oldChild) - InlineCostEstimator.getCost(this.newChild);
        }
    }
}

