/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE", "Unable to determine type of parameter {0} for exported function {1}");
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE", "Unable to determine return type for exported function {0}");
    private final List<Export> exports = Lists.newArrayList();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;

    ExternExportsPass(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.definitionMap = Maps.newHashMap();
        this.externsRoot = new Node(125);
        this.externsRoot.setIsSyntheticBlock(true);
        this.alreadyExportedPaths = Sets.newHashSet();
        this.mappedPaths = Maps.newHashMap();
    }

    @Override
    public void process(Node node, Node node2) {
        new NodeTraversal(this.compiler, this).traverse(node2);
        TreeSet<Export> treeSet = new TreeSet<Export>(new Comparator<Export>(){

            @Override
            public int compare(Export export, Export export2) {
                return export.getExportedPath().compareTo(export2.getExportedPath());
            }
        });
        treeSet.addAll(this.exports);
        for (Export export : treeSet) {
            export.generateExterns();
        }
    }

    public String getGeneratedExterns() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(false).setOutputTypes(true);
        return builder.build();
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 33: 
            case 38: {
                if (node2.getType() == 86 || node2.getType() == 118) {
                    this.definitionMap.put(node.getQualifiedName(), node2);
                }
                if (node2.getType() != 37) {
                    return;
                }
                ArrayList arrayList = Lists.newArrayList();
                ArrayList arrayList2 = Lists.newArrayList();
                arrayList.add("goog.exportSymbol");
                arrayList2.add("goog.exportProperty");
                arrayList.add("google_exportSymbol");
                arrayList2.add("google_exportProperty");
                if (arrayList2.contains(node.getQualifiedName())) {
                    this.handlePropertyExport(node2);
                }
                if (!arrayList.contains(node.getQualifiedName())) break;
                this.handleSymbolExport(node2);
            }
        }
    }

    private void handleSymbolExport(Node node) {
        if (node.getChildCount() != 3) {
            return;
        }
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node3.getNext();
        if (node3.getType() != 40) {
            return;
        }
        this.exports.add(new SymbolExport(node3.getString(), node4));
    }

    private void handlePropertyExport(Node node) {
        if (node.getChildCount() != 4) {
            return;
        }
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        if (node3.getQualifiedName() == null) {
            return;
        }
        if (node4.getType() != 40) {
            return;
        }
        this.exports.add(new PropertyExport(node3.getQualifiedName(), node4.getString(), node5));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String string, String string2, Node node) {
            super(string2, node);
            this.exportPath = string;
        }

        @Override
        String getExportedPath() {
            ArrayList arrayList = Lists.newArrayList((Object[])this.exportPath.split("\\."));
            for (int i = arrayList.size(); i > 0; --i) {
                String string = Joiner.on((String)".").join(Iterables.limit((Iterable)arrayList, (int)i));
                if (!ExternExportsPass.this.mappedPaths.containsKey(string)) continue;
                String string2 = (String)ExternExportsPass.this.mappedPaths.get(string);
                if (i < arrayList.size()) {
                    string2 = string2 + "." + Joiner.on((String)".").join(Iterables.skip((Iterable)arrayList, (int)i));
                }
                return string2 + "." + this.symbolName;
            }
            return this.exportPath + "." + this.symbolName;
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String string, Node node) {
            super(string, node);
            String string2 = node.getQualifiedName();
            if (string2 != null) {
                ExternExportsPass.this.mappedPaths.put(string2, string);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String string, Node node) {
            this.symbolName = string;
            this.value = node;
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getFunctionValue(this.value));
        }

        abstract String getExportedPath();

        protected void appendExtern(String string, Node node) {
            List<String> list = this.computePathPrefixes(string);
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                String string2 = list.get(i);
                boolean bl2 = i == list.size() - 1;
                boolean bl3 = bl = string2.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(string2) && !bl2;
                if (bl) continue;
                Node node2 = bl2 && node != null ? this.createExternFunction(node) : new Node(64);
                this.appendPathDefinition(string2, node2);
            }
        }

        private List<String> computePathPrefixes(String string) {
            ArrayList arrayList = Lists.newArrayList((Object[])string.split("\\."));
            ArrayList arrayList2 = Lists.newArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(Joiner.on((String)".").join(Iterables.limit((Iterable)arrayList, (int)(i + 1))));
            }
            return arrayList2;
        }

        private void appendPathDefinition(String string, Node node) {
            Node node2;
            if (!string.contains(".")) {
                node2 = NodeUtil.newVarNode(string, node);
            } else {
                Node node3 = NodeUtil.newQualifiedNameNode(ExternExportsPass.this.compiler.getCodingConvention(), string, -1, -1);
                node2 = NodeUtil.newExpr(new Node(86, node3, node));
            }
            ExternExportsPass.this.externsRoot.addChildToBack(node2);
            ExternExportsPass.this.alreadyExportedPaths.add(string);
        }

        private Node createExternFunction(Node node) {
            LinkedList linkedList = Lists.newLinkedList();
            for (Node node2 : NodeUtil.getFnParameters(node).children()) {
                linkedList.add(node2.cloneNode());
            }
            Node node3 = NodeUtil.newFunctionNode("", linkedList, new Node(125), -1, -1);
            this.checkForFunctionsWithUnknownTypes(node);
            node3.setJSType(node.getJSType());
            return node3;
        }

        private void checkForFunctionsWithUnknownTypes(Node node) {
            Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
            FunctionType functionType = (FunctionType)node.getJSType();
            if (functionType == null) {
                return;
            }
            JSDocInfo jSDocInfo = functionType.getJSDocInfo();
            JSType jSType = functionType.getReturnType();
            if (!functionType.isConstructor() && (jSType == null || jSType.isUnknownType())) {
                this.reportUnknownReturnType(node);
            }
            Node node2 = NodeUtil.getFnParameters(node).getFirstChild();
            Node node3 = functionType.getParametersNode().getFirstChild();
            while (node2 != null) {
                JSType jSType2 = node3.getJSType();
                if (jSType2 == null || jSType2.isUnknownType()) {
                    this.reportUnknownParameterType(node, node2);
                }
                node2 = node2.getNext();
                node3 = node3.getNext();
            }
        }

        private void reportUnknownParameterType(Node node, Node node2) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node2, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE, NodeUtil.getFunctionName(node), node2.getString()));
        }

        private void reportUnknownReturnType(Node node) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE, NodeUtil.getFunctionName(node)));
        }

        protected Node getFunctionValue(Node node) {
            Node node2;
            String string = this.value.getQualifiedName();
            if (string == null) {
                return null;
            }
            if (!ExternExportsPass.this.definitionMap.containsKey(string)) {
                return null;
            }
            Node node3 = (Node)ExternExportsPass.this.definitionMap.get(string);
            switch (node3.getType()) {
                case 86: {
                    node2 = node3.getLastChild();
                    break;
                }
                case 118: {
                    node2 = node3.getLastChild().getLastChild();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (node2.getType() != 105) {
                return null;
            }
            return node2;
        }
    }
}

