/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

class CrossModuleMethodMotion
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleMethodMotion.class.getName());
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;
    static final String STUB_METHOD_NAME = "JSCompiler_stubMethod";
    static final String UNSTUB_METHOD_NAME = "JSCompiler_unstubMethod";
    static final String STUB_DECLARATIONS = "var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}";

    CrossModuleMethodMotion(AbstractCompiler abstractCompiler, IdGenerator idGenerator, boolean bl) {
        this.compiler = abstractCompiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = abstractCompiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(abstractCompiler, this.moduleGraph, bl, false);
    }

    @Override
    public void process(Node node, Node node2) {
        if (this.moduleGraph != null && this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(node, node2);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> collection) {
        boolean bl = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : collection) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule jSModule = nameInfo.getDeepestCommonModuleRef();
            if (jSModule == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> iterator = nameInfo.getDeclarations().descendingIterator();
            while (iterator.hasNext()) {
                AnalyzePrototypeProperties.Symbol symbol = iterator.next();
                if (!(symbol instanceof AnalyzePrototypeProperties.Property)) continue;
                AnalyzePrototypeProperties.Property property = (AnalyzePrototypeProperties.Property)symbol;
                Node node = property.getValue();
                if (!this.moduleGraph.dependsOn(jSModule, property.getModule()) || node.getType() != 105) continue;
                Node node2 = property.getValueParent();
                Node node3 = property.getPrototype();
                int n = this.idGenerator.newId();
                node2.replaceChild(node, new Node(37, Node.newString(38, STUB_METHOD_NAME), Node.newNumber(n)).copyInformationFromForTree(node));
                Node node4 = this.compiler.getNodeForCodeInsertion(jSModule);
                node4.addChildToFront(new Node(130, new Node(86, new Node(33, node3.cloneTree(), Node.newString(40, nameInfo.name)), new Node(37, Node.newString(38, UNSTUB_METHOD_NAME), Node.newNumber(n), node))).copyInformationFromForTree(node));
                this.compiler.reportCodeChange();
                logger.fine("Moved method: " + node3.getQualifiedName() + "." + nameInfo.name + " from module " + property.getModule() + " to module " + jSModule);
            }
        }
        if (!bl && this.idGenerator.hasGeneratedAnyIds()) {
            Node node = this.compiler.parseSyntheticCode(STUB_DECLARATIONS);
            this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(node.removeChildren());
        }
    }

    static class IdGenerator
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private int currentId = 0;

        IdGenerator() {
        }

        boolean hasGeneratedAnyIds() {
            return this.currentId != 0;
        }

        int newId() {
            return this.currentId++;
        }
    }
}

