/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.List;

final class CombinedCompilerPass
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final CallbackWrapper[] callbacks;
    private final AbstractCompiler compiler;

    CombinedCompilerPass(AbstractCompiler abstractCompiler, NodeTraversal.Callback ... callbackArray) {
        this(abstractCompiler, Lists.newArrayList((Object[])callbackArray));
    }

    CombinedCompilerPass(AbstractCompiler abstractCompiler, List<NodeTraversal.Callback> list) {
        this.compiler = abstractCompiler;
        this.callbacks = new CallbackWrapper[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.callbacks[i] = new CallbackWrapper(list.get(i));
        }
    }

    static void traverse(AbstractCompiler abstractCompiler, Node node, List<NodeTraversal.Callback> list) {
        if (list.size() == 1) {
            NodeTraversal.traverse(abstractCompiler, node, list.get(0));
        } else {
            new CombinedCompilerPass(abstractCompiler, list).process(null, node);
        }
    }

    @Override
    public final void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        for (CallbackWrapper callbackWrapper : this.callbacks) {
            callbackWrapper.shouldTraverseIfActive(nodeTraversal, node, node2);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        for (CallbackWrapper callbackWrapper : this.callbacks) {
            callbackWrapper.visitOrMaybeActivate(nodeTraversal, node, node2);
        }
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        for (CallbackWrapper callbackWrapper : this.callbacks) {
            callbackWrapper.enterScopeIfActive(nodeTraversal);
        }
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        for (CallbackWrapper callbackWrapper : this.callbacks) {
            callbackWrapper.exitScopeIfActive(nodeTraversal);
        }
    }

    private static class CallbackWrapper {
        private final NodeTraversal.Callback callback;
        private final NodeTraversal.ScopedCallback scopedCallback;
        private Node waiting = null;

        private CallbackWrapper(NodeTraversal.Callback callback) {
            this.callback = callback;
            this.scopedCallback = callback instanceof NodeTraversal.ScopedCallback ? (NodeTraversal.ScopedCallback)callback : null;
        }

        void visitOrMaybeActivate(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isActive()) {
                this.callback.visit(nodeTraversal, node, node2);
            } else if (this.waiting == node) {
                this.waiting = null;
            }
        }

        void shouldTraverseIfActive(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isActive() && !this.callback.shouldTraverse(nodeTraversal, node, node2)) {
                this.waiting = node;
            }
        }

        void enterScopeIfActive(NodeTraversal nodeTraversal) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.enterScope(nodeTraversal);
            }
        }

        void exitScopeIfActive(NodeTraversal nodeTraversal) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.exitScope(nodeTraversal);
            }
        }

        boolean isActive() {
            return this.waiting == null;
        }
    }
}

