/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;

class CheckAccessControls
implements NodeTraversal.ScopedCallback,
CompilerPass {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.disabled("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.disabled("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.disabled("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.disabled("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.disabled("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private int deprecatedDepth = 0;
    private int methodDepth = 0;
    private JSType currentClass = null;

    CheckAccessControls(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.validator = abstractCompiler.getTypeValidator();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        if (!nodeTraversal.inGlobalScope()) {
            Node node;
            Node node2 = nodeTraversal.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(node2, node = node2.getParent())) {
                ++this.deprecatedDepth;
            }
            if (this.methodDepth == 0) {
                this.currentClass = this.getClassOfMethod(node2, node);
            }
            ++this.methodDepth;
        }
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        if (!nodeTraversal.inGlobalScope()) {
            Node node;
            Node node2 = nodeTraversal.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(node2, node = node2.getParent())) {
                --this.deprecatedDepth;
            }
            --this.methodDepth;
            if (this.methodDepth == 0) {
                this.currentClass = null;
            }
        }
    }

    private JSType getClassOfMethod(Node node, Node node2) {
        if (node2.getType() == 86) {
            Node node3 = node2.getFirstChild();
            if (node3.isQualifiedName()) {
                if (node3.getType() == 33) {
                    JSType jSType = node3.getJSType();
                    if (jSType != null && jSType.isConstructor()) {
                        return ((FunctionType)jSType).getInstanceType();
                    }
                    return this.normalizeClassType(node3.getFirstChild().getJSType());
                }
                return this.normalizeClassType(node3.getJSType());
            }
        } else if (NodeUtil.isFunctionDeclaration(node) || node2.getType() == 38) {
            return this.normalizeClassType(node.getJSType());
        }
        return null;
    }

    private JSType normalizeClassType(JSType jSType) {
        FunctionType functionType;
        if (jSType == null || jSType.isUnknownType()) {
            return jSType;
        }
        if (jSType.isConstructor()) {
            return ((FunctionType)jSType).getInstanceType();
        }
        if (jSType.isFunctionPrototypeType() && (functionType = ((FunctionPrototypeType)jSType).getOwnerFunction()).isConstructor()) {
            return functionType.getInstanceType();
        }
        return jSType;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 38: {
                this.checkNameDeprecation(nodeTraversal, node, node2);
                this.checkNameVisibility(nodeTraversal, node, node2);
                break;
            }
            case 33: {
                this.checkPropertyDeprecation(nodeTraversal, node, node2);
                this.checkPropertyVisibility(nodeTraversal, node, node2);
                break;
            }
            case 30: {
                this.checkConstructorDeprecation(nodeTraversal, node, node2);
            }
        }
    }

    private void checkConstructorDeprecation(NodeTraversal nodeTraversal, Node node, Node node2) {
        String string;
        JSType jSType = node.getJSType();
        if (jSType != null && (string = CheckAccessControls.getTypeDeprecationInfo(jSType)) != null && this.shouldEmitDeprecationWarning(nodeTraversal, node, node2)) {
            if (!string.isEmpty()) {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_CLASS_REASON, jSType.toString(), string));
            } else {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_CLASS, jSType.toString()));
            }
        }
    }

    private void checkNameDeprecation(NodeTraversal nodeTraversal, Node node, Node node2) {
        JSDocInfo jSDocInfo;
        if (node2.getType() == 105 || node2.getType() == 118 || node2.getType() == 30) {
            return;
        }
        Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
        JSDocInfo jSDocInfo2 = jSDocInfo = var == null ? null : var.getJSDocInfo();
        if (jSDocInfo != null && jSDocInfo.isDeprecated() && this.shouldEmitDeprecationWarning(nodeTraversal, node, node2)) {
            if (jSDocInfo.getDeprecationReason() != null) {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_NAME_REASON, node.getString(), jSDocInfo.getDeprecationReason()));
            } else {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_NAME, node.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal nodeTraversal, Node node, Node node2) {
        String string;
        if (node2.getType() == 30) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(node.getFirstChild().getJSType()));
        String string2 = node.getLastChild().getString();
        if (objectType != null && (string = CheckAccessControls.getPropertyDeprecationInfo(objectType, string2)) != null && this.shouldEmitDeprecationWarning(nodeTraversal, node, node2)) {
            if (!string.isEmpty()) {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_PROP_REASON, string2, this.validator.getReadableJSTypeName(node.getFirstChild(), true), string));
            } else {
                this.compiler.report(nodeTraversal.makeError(node, DEPRECATED_PROP, string2, this.validator.getReadableJSTypeName(node.getFirstChild(), true)));
            }
        }
    }

    private void checkNameVisibility(NodeTraversal nodeTraversal, Node node, Node node2) {
        JSDocInfo.Visibility visibility;
        JSDocInfo jSDocInfo;
        Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
        if (var != null && (jSDocInfo = var.getJSDocInfo()) != null && (visibility = jSDocInfo.getVisibility()) == JSDocInfo.Visibility.PRIVATE && !nodeTraversal.getInput().getName().equals(jSDocInfo.getSourceName())) {
            if (jSDocInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(node2)) {
                return;
            }
            this.compiler.report(nodeTraversal.makeError(node, BAD_PRIVATE_GLOBAL_ACCESS, node.getString(), jSDocInfo.getSourceName()));
        }
    }

    private void checkPropertyVisibility(NodeTraversal nodeTraversal, Node node, Node node2) {
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(node.getFirstChild().getJSType()));
        String string = node.getLastChild().getString();
        if (objectType != null) {
            boolean bl;
            boolean bl2 = bl = nodeTraversal.inGlobalScope() && node2.getType() == 86 && node2.getFirstChild() == node;
            if (bl) {
                objectType = objectType.getImplicitPrototype();
            }
            JSDocInfo jSDocInfo = null;
            while (objectType != null && ((jSDocInfo = objectType.getOwnPropertyJSDocInfo(string)) == null || jSDocInfo.getVisibility() == JSDocInfo.Visibility.INHERITED)) {
                objectType = objectType.getImplicitPrototype();
            }
            if (objectType == null) {
                return;
            }
            boolean bl3 = nodeTraversal.getInput().getName().equals(jSDocInfo.getSourceName());
            JSDocInfo.Visibility visibility = jSDocInfo.getVisibility();
            JSType jSType = this.normalizeClassType(objectType);
            if (bl) {
                JSDocInfo.Visibility visibility2;
                JSDocInfo jSDocInfo2 = node2.getJSDocInfo();
                JSDocInfo.Visibility visibility3 = visibility2 = jSDocInfo2 == null ? JSDocInfo.Visibility.INHERITED : jSDocInfo2.getVisibility();
                if (visibility == JSDocInfo.Visibility.PRIVATE && !bl3) {
                    this.compiler.report(nodeTraversal.makeError(node, PRIVATE_OVERRIDE, objectType.toString()));
                } else if (visibility2 != JSDocInfo.Visibility.INHERITED && visibility2 != visibility) {
                    this.compiler.report(nodeTraversal.makeError(node, VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), visibility2.name()));
                }
            } else {
                if (bl3) {
                    return;
                }
                if (visibility == JSDocInfo.Visibility.PRIVATE && (this.currentClass == null || jSType.differsFrom(this.currentClass))) {
                    if (jSDocInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(node2)) {
                        return;
                    }
                    this.compiler.report(nodeTraversal.makeError(node, BAD_PRIVATE_PROPERTY_ACCESS, string, this.validator.getReadableJSTypeName(node.getFirstChild(), true)));
                } else if (!(visibility != JSDocInfo.Visibility.PROTECTED || this.currentClass != null && this.currentClass.isSubtype(jSType))) {
                    this.compiler.report(nodeTraversal.makeError(node, BAD_PROTECTED_PROPERTY_ACCESS, string, this.validator.getReadableJSTypeName(node.getFirstChild(), true)));
                }
            }
        }
    }

    private static boolean isValidPrivateConstructorAccess(Node node) {
        return node.getType() != 30;
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (nodeTraversal.inGlobalScope() && (node2.getType() != 37 || node2.getFirstChild() != node) && node.getType() != 30) {
            return false;
        }
        if (node.getType() == 33 && node == node2.getFirstChild() && NodeUtil.isAssignmentOp(node2)) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(nodeTraversal);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal nodeTraversal) {
        Node node = nodeTraversal.getScopeRoot();
        Node node2 = node.getParent();
        return this.deprecatedDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(nodeTraversal.getScope().getTypeOfThis()) != null || node2 != null && node2.getType() == 86 && CheckAccessControls.getTypeDeprecationInfo(this.getClassOfMethod(node, node2)) != null;
    }

    private static boolean isDeprecatedFunction(Node node, Node node2) {
        JSType jSType;
        if (node.getType() == 105 && (jSType = node.getJSType()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(jSType) != null;
        }
        return false;
    }

    private static String getTypeDeprecationInfo(JSType jSType) {
        ObjectType objectType;
        if (jSType == null) {
            return null;
        }
        JSDocInfo jSDocInfo = jSType.getJSDocInfo();
        if (jSDocInfo != null && jSDocInfo.isDeprecated()) {
            if (jSDocInfo.getDeprecationReason() != null) {
                return jSDocInfo.getDeprecationReason();
            }
            return "";
        }
        ObjectType objectType2 = ObjectType.cast(jSType);
        if (objectType2 != null && (objectType = objectType2.getImplicitPrototype()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(objectType);
        }
        return null;
    }

    private static String getPropertyDeprecationInfo(ObjectType objectType, String string) {
        JSDocInfo jSDocInfo = objectType.getOwnPropertyJSDocInfo(string);
        if (jSDocInfo != null && jSDocInfo.isDeprecated()) {
            if (jSDocInfo.getDeprecationReason() != null) {
                return jSDocInfo.getDeprecationReason();
            }
            return "";
        }
        ObjectType objectType2 = objectType.getImplicitPrototype();
        if (objectType2 != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(objectType2, string);
        }
        return null;
    }

    private static JSType dereference(JSType jSType) {
        return jSType == null ? null : jSType.dereference();
    }
}

