/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

class AmbiguateProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AmbiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final List<Node> stringNodesToRename = Lists.newArrayList();
    private final char[] reservedCharacters;
    private final Map<String, Property> propertyMap = Maps.newHashMap();
    private final Set<String> externedNames = Sets.newHashSet();
    private final Set<String> quotedNames = Sets.newHashSet();
    private final Map<String, String> renamingMap = Maps.newHashMap();
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property property, Property property2) {
            if (property.numOccurrences != property2.numOccurrences) {
                return property2.numOccurrences - property.numOccurrences;
            }
            return property.oldName.compareTo(property2.oldName);
        }
    };
    private BiMap<JSType, Integer> intForType = HashBiMap.create();
    private Map<JSType, JSTypeBitSet> relatedBitsets = Maps.newHashMap();
    private final Set<JSType> invalidatingTypes;
    static final String SKIP_PREFIX = "JSAbstractCompiler";

    AmbiguateProperties(AbstractCompiler abstractCompiler, char[] cArray) {
        Preconditions.checkState((boolean)abstractCompiler.isNormalized());
        this.compiler = abstractCompiler;
        this.reservedCharacters = cArray;
        JSTypeRegistry jSTypeRegistry = abstractCompiler.getTypeRegistry();
        this.invalidatingTypes = Sets.newHashSet((Object[])new JSType[]{jSTypeRegistry.getNativeType(JSTypeNative.ALL_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.NO_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.NULL_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.VOID_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), jSTypeRegistry.getNativeType(JSTypeNative.GLOBAL_THIS), jSTypeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), jSTypeRegistry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), jSTypeRegistry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), jSTypeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)});
        for (TypeValidator.TypeMismatch typeMismatch : abstractCompiler.getTypeValidator().getMismatches()) {
            this.addInvalidatingType(typeMismatch.typeA);
            this.addInvalidatingType(typeMismatch.typeB);
        }
    }

    private void addInvalidatingType(JSType jSType) {
        if ((jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                this.addInvalidatingType(jSType2);
            }
        }
        this.invalidatingTypes.add(jSType);
        ObjectType objectType = ObjectType.cast(jSType);
        if (objectType instanceof InstanceObjectType) {
            this.invalidatingTypes.add(objectType.getImplicitPrototype());
        }
    }

    Map<String, String> getRenamingMap() {
        return this.renamingMap;
    }

    private int getIntForType(JSType jSType) {
        if (this.intForType.containsKey((Object)jSType)) {
            return (Integer)this.intForType.get((Object)jSType);
        }
        int n = this.intForType.size() + 1;
        this.intForType.put((Object)jSType, (Object)n);
        return n;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new ProcessExterns());
        NodeTraversal.traverse(this.compiler, node2, new ProcessProperties());
        HashSet<String> hashSet = new HashSet<String>(this.externedNames.size() + this.quotedNames.size());
        hashSet.addAll(this.externedNames);
        hashSet.addAll(this.quotedNames);
        int n = 0;
        int n2 = 0;
        TreeSet<Property> treeSet = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        for (Property object2 : this.propertyMap.values()) {
            if (!object2.skipAmbiguating) {
                ++n;
                treeSet.add(object2);
                continue;
            }
            ++n2;
            hashSet.add(object2.oldName);
        }
        PropertyGraph propertyGraph = new PropertyGraph(Lists.newLinkedList(treeSet));
        GraphColoring.GreedyGraphColoring greedyGraphColoring = new GraphColoring.GreedyGraphColoring(propertyGraph, FREQUENCY_COMPARATOR);
        int n3 = ((GraphColoring)greedyGraphColoring).color();
        NameGenerator nameGenerator = new NameGenerator(hashSet, "", this.reservedCharacters);
        HashMap hashMap = Maps.newHashMap();
        for (int i = 0; i < n3; ++i) {
            hashMap.put(i, nameGenerator.generateNextName());
        }
        for (GraphNode graphNode : propertyGraph.getNodes()) {
            ((Property)graphNode.getValue()).newName = (String)hashMap.get(graphNode.getAnnotation().hashCode());
            this.renamingMap.put(((Property)graphNode.getValue()).oldName, ((Property)graphNode.getValue()).newName);
        }
        for (Node node3 : this.stringNodesToRename) {
            String string = node3.getString();
            Property property = this.propertyMap.get(string);
            if (property == null || property.newName == null) continue;
            Preconditions.checkState((boolean)string.equals(property.oldName));
            if (property.newName.equals(string)) continue;
            node3.setString(property.newName);
            this.compiler.reportCodeChange();
        }
        logger.info("Collapsed " + n + " properties into " + n3 + " and skipped renaming " + n2 + " properties.");
    }

    private BitSet getRelatedTypesOnNonUnion(JSType jSType) {
        if (this.relatedBitsets.containsKey(jSType)) {
            return this.relatedBitsets.get(jSType);
        }
        throw new RuntimeException("Related types should have been computed for type: " + jSType + " but have not been.");
    }

    private void computeRelatedTypes(JSType jSType) {
        if (jSType instanceof UnionType && (jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                this.computeRelatedTypes(jSType2);
            }
            return;
        }
        if (this.relatedBitsets.containsKey(jSType)) {
            return;
        }
        JSTypeBitSet jSTypeBitSet = new JSTypeBitSet(this.intForType.size());
        this.relatedBitsets.put(jSType, jSTypeBitSet);
        jSTypeBitSet.set(this.getIntForType(jSType));
        if (jSType instanceof FunctionPrototypeType) {
            this.addRelatedInstance(((FunctionPrototypeType)jSType).getOwnerFunction(), jSTypeBitSet);
            return;
        }
        FunctionType functionType = jSType.toObjectType().getConstructor();
        if (functionType != null && functionType.getSubTypes() != null) {
            for (FunctionType functionType2 : functionType.getSubTypes()) {
                this.addRelatedInstance(functionType2, jSTypeBitSet);
            }
        }
        for (FunctionType functionType2 : this.compiler.getTypeRegistry().getDirectImplementors(jSType.toObjectType())) {
            this.addRelatedInstance(functionType2, jSTypeBitSet);
        }
    }

    private void addRelatedInstance(FunctionType functionType, JSTypeBitSet jSTypeBitSet) {
        if (functionType.hasInstanceType()) {
            ObjectType objectType = functionType.getInstanceType();
            jSTypeBitSet.set(this.getIntForType(objectType.getImplicitPrototype()));
            this.computeRelatedTypes(objectType);
            jSTypeBitSet.or(this.relatedBitsets.get(objectType));
        }
    }

    private boolean isInvalidatingType(JSType jSType) {
        if (jSType instanceof UnionType && (jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                if (!this.isInvalidatingType(jSType2)) continue;
                return true;
            }
            return false;
        }
        ObjectType objectType = ObjectType.cast(jSType);
        return objectType == null || this.invalidatingTypes.contains(objectType) || !objectType.hasReferenceName() || objectType.isUnknownType() || objectType.isEnumType() || objectType.autoboxesTo() != null;
    }

    private Property getProperty(String string) {
        Property property = this.propertyMap.get(string);
        if (property == null) {
            property = new Property(string);
            this.propertyMap.put(string, property);
        }
        return property;
    }

    private JSType getJSType(Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jSType;
    }

    private class JSTypeBitSet
    extends BitSet {
        private static final long serialVersionUID = 1L;

        private JSTypeBitSet(int n) {
            super(n);
        }

        private JSTypeBitSet() {
        }

        @Override
        public String toString() {
            int n = 0;
            int n2 = 0;
            ArrayList arrayList = Lists.newArrayList();
            while (-1 != (n2 = this.nextSetBit(n))) {
                arrayList.add(((JSType)AmbiguateProperties.this.intForType.inverse().get((Object)n2)).toString());
                n = n2 + 1;
            }
            return Joiner.on((String)" && ").join((Iterable)arrayList);
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        boolean skipAmbiguating;
        JSTypeBitSet relatedTypes;

        Property(String string) {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
            this.oldName = string;
            if (string.startsWith(AmbiguateProperties.SKIP_PREFIX)) {
                this.skipAmbiguating = true;
            }
        }

        void addType(JSType jSType) {
            if (this.skipAmbiguating) {
                return;
            }
            ++this.numOccurrences;
            if (jSType instanceof UnionType && (jSType = jSType.restrictByNotNullOrUndefined()) instanceof UnionType) {
                for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                    this.addNonUnionType(jSType2);
                }
                return;
            }
            this.addNonUnionType(jSType);
        }

        private void addNonUnionType(JSType jSType) {
            if (this.skipAmbiguating || AmbiguateProperties.this.isInvalidatingType(jSType)) {
                this.skipAmbiguating = true;
                return;
            }
            if (!this.relatedTypes.get(AmbiguateProperties.this.getIntForType(jSType))) {
                AmbiguateProperties.this.computeRelatedTypes(jSType);
                this.relatedTypes.or(AmbiguateProperties.this.getRelatedTypesOnNonUnion(jSType));
            }
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: {
                    Node node3 = node.getFirstChild().getNext();
                    JSType jSType = AmbiguateProperties.this.getJSType(node.getFirstChild());
                    this.maybeMarkCandidate(node3, jSType, nodeTraversal);
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() != 40) continue;
                        if (!node4.isQuotedString()) {
                            JSType jSType = AmbiguateProperties.this.getJSType(node.getFirstChild());
                            this.maybeMarkCandidate(node4, jSType, nodeTraversal);
                            continue;
                        }
                        AmbiguateProperties.this.quotedNames.add(node4.getString());
                    }
                    break;
                }
                case 35: {
                    Node node5 = node.getLastChild();
                    if (node5.getType() != 40) break;
                    AmbiguateProperties.this.quotedNames.add(node5.getString());
                }
            }
        }

        private void maybeMarkCandidate(Node node, JSType jSType, NodeTraversal nodeTraversal) {
            String string = node.getString();
            if (!AmbiguateProperties.this.externedNames.contains(string)) {
                AmbiguateProperties.this.stringNodesToRename.add(node);
                this.recordProperty(string, jSType);
            }
        }

        private Property recordProperty(String string, JSType jSType) {
            Property property = AmbiguateProperties.this.getProperty(string);
            property.addType(jSType);
            return property;
        }
    }

    private class ProcessExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExterns() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: {
                    Node node3 = node.getFirstChild().getNext();
                    AmbiguateProperties.this.externedNames.add(node3.getString());
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() != 40) continue;
                        AmbiguateProperties.this.externedNames.add(node4.getString());
                    }
                    break;
                }
            }
        }
    }

    class PropertyGraphNode
    implements GraphNode<Property, Void> {
        Property property;
        protected Annotation annotation;

        PropertyGraphNode(Property property) {
            this.property = property;
        }

        @Override
        public Property getValue() {
            return this.property;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }
    }

    class PropertySubGraph
    implements SubGraph<Property, Void> {
        JSTypeBitSet relatedTypes;

        PropertySubGraph() {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
        }

        @Override
        public boolean isIndependentOf(Property property) {
            return !this.relatedTypes.intersects(property.relatedTypes);
        }

        @Override
        public void addNode(Property property) {
            this.relatedTypes.or(property.relatedTypes);
        }
    }

    class PropertyGraph
    implements AdjacencyGraph<Property, Void> {
        protected final Map<Property, PropertyGraphNode> nodes = Maps.newHashMap();

        PropertyGraph(Collection<Property> collection) {
            for (Property property : collection) {
                this.nodes.put(property, new PropertyGraphNode(property));
            }
        }

        @Override
        public List<GraphNode<Property, Void>> getNodes() {
            return Lists.newArrayList(this.nodes.values());
        }

        @Override
        public GraphNode<Property, Void> getNode(Property property) {
            return this.nodes.get(property);
        }

        @Override
        public SubGraph<Property, Void> newSubGraph() {
            return new PropertySubGraph();
        }

        @Override
        public void clearNodeAnnotations() {
            for (PropertyGraphNode propertyGraphNode : this.nodes.values()) {
                propertyGraphNode.setAnnotation(null);
            }
        }

        @Override
        public int getWeight(Property property) {
            return property.numOccurrences;
        }
    }
}

