/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JvmMetrics;
import com.google.javascript.rhino.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class PerformanceTracker {
    private final Node jsRoot;
    private final boolean trackSize;
    private final boolean trackGzippedSize;
    private final CodeChangeHandler.RecentChange codeChange = new CodeChangeHandler.RecentChange();
    private int curCodeSizeEstimate = -1;
    private int curZippedCodeSizeEstimate = -1;
    private Deque<String> currentRunningPass = new ArrayDeque<String>();
    private final Map<String, Stats> summary = Maps.newHashMap();
    private ImmutableMap<String, Stats> summaryCopy = null;
    private final List<Stats> log = Lists.newArrayList();

    PerformanceTracker(Node jsRoot, CompilerOptions.TracerMode mode) {
        this.jsRoot = jsRoot;
        switch (mode) {
            case TIMING_ONLY: {
                this.trackSize = false;
                this.trackGzippedSize = false;
                break;
            }
            case RAW_SIZE: {
                this.trackSize = true;
                this.trackGzippedSize = false;
                break;
            }
            case ALL: {
                this.trackSize = true;
                this.trackGzippedSize = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String passName) {
        this.currentRunningPass.push(passName);
        this.codeChange.reset();
    }

    void recordPassStop(String passName, long result) {
        String currentPassName = this.currentRunningPass.pop();
        if (!passName.equals(currentPassName)) {
            throw new RuntimeException(passName + " is not running.");
        }
        CodeSizeEstimatePrinter printer = null;
        if (this.codeChange.hasCodeChanged() && (this.trackSize || this.trackGzippedSize)) {
            printer = this.estimateCodeSize(this.jsRoot);
        }
        Stats logStats = new Stats(currentPassName);
        this.log.add(logStats);
        this.updateStats(logStats, result, printer);
        Stats summaryStats = this.summary.get(passName);
        if (summaryStats == null) {
            summaryStats = new Stats(passName);
            this.summary.put(passName, summaryStats);
        }
        this.updateStats(summaryStats, result, printer);
        if (printer != null) {
            if (this.trackSize) {
                this.curCodeSizeEstimate = printer.calcSize();
            }
            if (this.trackGzippedSize) {
                this.curZippedCodeSizeEstimate = printer.calcZippedSize();
            }
        }
    }

    private void updateStats(Stats stats, long result, CodeSizeEstimatePrinter printer) {
        stats.runtime += result;
        ++stats.runs;
        if (this.codeChange.hasCodeChanged()) {
            ++stats.changes;
        }
        if (printer != null) {
            PerformanceTracker.recordSizeChange(this.curCodeSizeEstimate, printer.calcSize(), stats);
            PerformanceTracker.recordGzSizeChange(this.curZippedCodeSizeEstimate, printer.calcZippedSize(), stats);
        }
    }

    private static void recordSizeChange(int oldSize, int newSize, Stats record) {
        int delta;
        if (oldSize != -1 && (delta = oldSize - newSize) > 0) {
            record.diff += delta;
        }
        if (newSize != -1) {
            record.size = newSize;
        }
    }

    private static void recordGzSizeChange(int oldSize, int newSize, Stats record) {
        int delta;
        if (oldSize != -1 && (delta = oldSize - newSize) > 0) {
            record.gzDiff += delta;
        }
        if (newSize != -1) {
            record.gzSize = newSize;
        }
    }

    private final CodeSizeEstimatePrinter estimateCodeSize(Node root) {
        CodeSizeEstimatePrinter cp = new CodeSizeEstimatePrinter(this.trackGzippedSize);
        CodeGenerator cg = CodeGenerator.forCostEstimation(cp);
        cg.add(root);
        return cp;
    }

    public ImmutableMap<String, Stats> getStats() {
        if (this.summaryCopy == null) {
            this.summaryCopy = ImmutableMap.copyOf(this.summary);
        }
        return this.summaryCopy;
    }

    public void outputTracerReport(PrintStream pstr) {
        JvmMetrics.maybeWriteJvmMetrics(pstr, "verbose:pretty:all");
        OutputStreamWriter output = new OutputStreamWriter(pstr);
        try {
            int runtime = 0;
            int runs = 0;
            int changes = 0;
            int diff = 0;
            int gzDiff = 0;
            output.write("Summary:\n");
            output.write("pass,runtime,runs,changingRuns,reduction,gzReduction\n");
            ArrayList<Map.Entry<String, Stats>> a = new ArrayList<Map.Entry<String, Stats>>();
            for (Map.Entry<String, Stats> entry : this.summary.entrySet()) {
                a.add(entry);
            }
            Collections.sort(a, new CmpEntries());
            for (Map.Entry<String, Stats> entry : a) {
                String key = entry.getKey();
                Stats stats = entry.getValue();
                output.write(key);
                output.write(",");
                output.write(String.valueOf(stats.runtime));
                runtime = (int)((long)runtime + stats.runtime);
                output.write(",");
                output.write(String.valueOf(stats.runs));
                runs += stats.runs;
                output.write(",");
                output.write(String.valueOf(stats.changes));
                changes += stats.changes;
                output.write(",");
                output.write(String.valueOf(stats.diff));
                diff += stats.diff;
                output.write(",");
                output.write(String.valueOf(stats.gzDiff));
                gzDiff += stats.gzDiff;
                output.write("\n");
            }
            output.write("TOTAL");
            output.write(",");
            output.write(String.valueOf(runtime));
            output.write(",");
            output.write(String.valueOf(runs));
            output.write(",");
            output.write(String.valueOf(changes));
            output.write(",");
            output.write(String.valueOf(diff));
            output.write(",");
            output.write(String.valueOf(gzDiff));
            output.write("\n");
            output.write("\n");
            output.write("Log:\n");
            output.write("pass,runtime,runs,changingRuns,reduction,gzReduction,size,gzSize\n");
            for (Stats stats : this.log) {
                output.write(stats.pass);
                output.write(",");
                output.write(String.valueOf(stats.runtime));
                output.write(",");
                output.write(String.valueOf(stats.runs));
                output.write(",");
                output.write(String.valueOf(stats.changes));
                output.write(",");
                output.write(String.valueOf(stats.diff));
                output.write(",");
                output.write(String.valueOf(stats.gzDiff));
                output.write(",");
                output.write(String.valueOf(stats.size));
                output.write(",");
                output.write(String.valueOf(stats.gzSize));
                output.write("\n");
            }
            output.write("\n");
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final class CodeSizeEstimatePrinter
    extends CodeConsumer {
        private final boolean trackGzippedSize;
        private int size = 0;
        private char lastChar = '\u0000';
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final GZIPOutputStream stream;

        private CodeSizeEstimatePrinter(boolean trackGzippedSize) {
            this.trackGzippedSize = trackGzippedSize;
            try {
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void append(String str) {
            int len = str.length();
            if (len > 0) {
                this.size += len;
                this.lastChar = str.charAt(len - 1);
                if (this.trackGzippedSize) {
                    try {
                        this.stream.write(str.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        char getLastChar() {
            return this.lastChar;
        }

        private int calcSize() {
            return this.size;
        }

        private int calcZippedSize() {
            if (this.trackGzippedSize) {
                try {
                    this.stream.finish();
                    this.stream.flush();
                    this.stream.close();
                    return this.output.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return -1;
        }
    }

    class CmpEntries
    implements Comparator<Map.Entry<String, Stats>> {
        CmpEntries() {
        }

        @Override
        public int compare(Map.Entry<String, Stats> e1, Map.Entry<String, Stats> e2) {
            return (int)(e1.getValue().runtime - e2.getValue().runtime);
        }
    }

    public static class Stats {
        public final String pass;
        public long runtime = 0L;
        public int runs = 0;
        public int changes = 0;
        public int diff = 0;
        public int gzDiff = 0;
        public int size = 0;
        public int gzSize = 0;

        public Stats(String pass) {
            this.pass = pass;
        }
    }
}

