/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeInference;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import java.util.Map;

class TypeInferencePass
implements CompilerPass {
    static final DiagnosticType DATAFLOW_ERROR = DiagnosticType.warning("JSC_INTERNAL_ERROR_DATAFLOW", "non-monotonic data-flow analysis");
    private final AbstractCompiler compiler;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private Scope topScope;
    private ScopeCreator scopeCreator;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;

    TypeInferencePass(AbstractCompiler compiler, ReverseAbstractInterpreter reverseInterpreter, Scope topScope, ScopeCreator scopeCreator) {
        this.compiler = compiler;
        this.reverseInterpreter = reverseInterpreter;
        this.topScope = topScope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionsMap = Maps.newHashMap();
        for (CodingConvention.AssertionFunctionSpec assertionFucntion : compiler.getCodingConvention().getAssertionFunctions()) {
            this.assertionFunctionsMap.put(assertionFucntion.getFunctionName(), assertionFucntion);
        }
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Node externsAndJs = jsRoot.getParent();
        Preconditions.checkState((externsAndJs != null ? 1 : 0) != 0);
        Preconditions.checkState((externsRoot == null || externsAndJs.hasChild(externsRoot) ? 1 : 0) != 0);
        this.inferTypes(externsAndJs);
    }

    void inferTypes(Node node) {
        NodeTraversal inferTypes = new NodeTraversal(this.compiler, new TypeInferringCallback(), this.scopeCreator);
        inferTypes.traverseWithScope(node, this.topScope);
    }

    void inferTypes(NodeTraversal t, Node n, Scope scope) {
        TypeInference typeInference = new TypeInference(this.compiler, this.computeCfg(n), this.reverseInterpreter, scope, this.assertionFunctionsMap);
        try {
            typeInference.analyze();
            this.compiler.getTypeRegistry().resolveTypesInScope(scope);
        }
        catch (DataFlowAnalysis.MaxIterationsExceededException e) {
            this.compiler.report(t.makeError(n, DATAFLOW_ERROR, new String[0]));
        }
    }

    private ControlFlowGraph<Node> computeCfg(Node n) {
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, n);
        return cfa.getCfg();
    }

    private class TypeInferringCallback
    implements NodeTraversal.ScopedCallback {
        private TypeInferringCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Scope scope = t.getScope();
            Node node = t.getCurrentNode();
            if (scope.isGlobal()) {
                TypeInferencePass.this.inferTypes(t, node, scope);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            Scope scope = t.getScope();
            Node node = t.getCurrentNode();
            if (scope.isLocal()) {
                TypeInferencePass.this.inferTypes(t, node, scope);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

