/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "be" locale.
 */
public class LocalizedNamesImpl_be extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BY",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BL",
        "CI",
        "CP",
        "DG",
        "EA",
        "FO",
        "GG",
        "GU",
        "IC",
        "IM",
        "JE",
        "MF",
        "PM",
        "PN",
        "PR",
        "SM",
        "TA",
        "UM",
        "YT",
        "AE",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "OM",
        "AS",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AF",
        "BS",
        "BG",
        "BO",
        "BD",
        "BB",
        "BW",
        "BH",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BA",
        "BR",
        "BN",
        "IO",
        "BV",
        "BF",
        "BI",
        "BT",
        "VN",
        "VU",
        "VA",
        "GB",
        "HU",
        "VE",
        "VG",
        "VI",
        "QO",
        "GA",
        "HT",
        "GM",
        "GH",
        "HN",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GI",
        "HK",
        "GE",
        "GD",
        "GL",
        "GR",
        "HM",
        "DM",
        "DO",
        "DK",
        "DJ",
        "EG",
        "YE",
        "EU",
        "ZM",
        "EH",
        "ZW",
        "US",
        "JO",
        "IL",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "CV",
        "KZ",
        "KY",
        "CC",
        "CO",
        "CX",
        "KH",
        "CM",
        "KM",
        "CA",
        "QA",
        "KE",
        "CY",
        "KI",
        "CN",
        "CG",
        "CD",
        "CR",
        "CU",
        "KW",
        "CK",
        "KG",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MM",
        "MG",
        "MZ",
        "MO",
        "MK",
        "MW",
        "MY",
        "MD",
        "ML",
        "MV",
        "MT",
        "MC",
        "MN",
        "MA",
        "MQ",
        "MH",
        "MU",
        "MR",
        "MX",
        "FM",
        "MS",
        "NA",
        "NO",
        "NR",
        "NP",
        "NE",
        "NG",
        "AN",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NF",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PT",
        "ZA",
        "GS",
        "KR",
        "KP",
        "MP",
        "PE",
        "PL",
        "RU",
        "RW",
        "RO",
        "RE",
        "SB",
        "SV",
        "SO",
        "WS",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SH",
        "SC",
        "SN",
        "RS",
        "SG",
        "SY",
        "SK",
        "SI",
        "SD",
        "SR",
        "SL",
        "VC",
        "KN",
        "LC",
        "TJ",
        "TW",
        "TH",
        "TK",
        "TO",
        "TZ",
        "TG",
        "TT",
        "TV",
        "TN",
        "TM",
        "TR",
        "TC",
        "UG",
        "UZ",
        "UA",
        "WF",
        "UY",
        "TL",
        "FJ",
        "PH",
        "FI",
        "FK",
        "PF",
        "GF",
        "TF",
        "FR",
        "HR",
        "CF",
        "TD",
        "ME",
        "CL",
        "CZ",
        "CH",
        "SE",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Свет");
    namesMap.put("002", "Афрыка");
    namesMap.put("003", "Паўночная Амэрыка");
    namesMap.put("005", "Паўднёвая Амэрыка");
    namesMap.put("009", "Акіянія");
    namesMap.put("011", "Заходняя Афрыка");
    namesMap.put("013", "Цэнтральная Амэрыка");
    namesMap.put("014", "Усходняя Афрыка");
    namesMap.put("015", "Паўночная Афрыка");
    namesMap.put("017", "Цэнтральная Афрыка");
    namesMap.put("018", "Паўднёвая Афрыка");
    namesMap.put("019", "Паўночная і Паўднёвая Амерыкі");
    namesMap.put("021", "ЗША і Канада");
    namesMap.put("029", "Карыбскія астравы");
    namesMap.put("030", "Усходняя Азія");
    namesMap.put("034", "Паўднёвая Азія");
    namesMap.put("035", "Паўднёва-Усходняя Азія");
    namesMap.put("039", "Паўднёвая Еўропа");
    namesMap.put("053", "Аўстралія і Новая Зэландыя");
    namesMap.put("061", "Палінезія");
    namesMap.put("062", "Паўднёва-Цэнтральная Азія");
    namesMap.put("142", "Азія");
    namesMap.put("143", "Цэнтральная Азія");
    namesMap.put("145", "Заходняя Азія");
    namesMap.put("150", "Еўропа");
    namesMap.put("151", "Усходняя Еўропа");
    namesMap.put("154", "Паўночная Еўропа");
    namesMap.put("155", "Заходняя Еўропа");
    namesMap.put("172", "Садружнасць Незалежных Дзяржаў");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Аб'яднаныя Арабскія Эміраты");
    namesMap.put("AF", "Афганістан");
    namesMap.put("AG", "Антыгуа і Барбуда");
    namesMap.put("AI", "Ангуілля");
    namesMap.put("AL", "Албанія");
    namesMap.put("AM", "Арменія");
    namesMap.put("AN", "Нідэрландскія Антылы");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктыка");
    namesMap.put("AR", "Аргенціна");
    namesMap.put("AS", "Амерыканскае Самоа");
    namesMap.put("AT", "Аўстрыя");
    namesMap.put("AU", "Аўстралія");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландскія астравы");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Боснія і Герцагавіна");
    namesMap.put("BB", "Барбадас");
    namesMap.put("BD", "Бангладэш");
    namesMap.put("BE", "Бельгія");
    namesMap.put("BF", "Буркіна-Фасо");
    namesMap.put("BG", "Балгарыя");
    namesMap.put("BH", "Бахрэйн");
    namesMap.put("BI", "Бурундзі");
    namesMap.put("BJ", "Бенін");
    namesMap.put("BM", "Бермудскія астравы");
    namesMap.put("BN", "Бруней-Дарусалам");
    namesMap.put("BO", "Балівія");
    namesMap.put("BR", "Бразілія");
    namesMap.put("BS", "Багамскія Астравы");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Бувэ востраў");
    namesMap.put("BW", "Батсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Беліз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Какосавыя астравы");
    namesMap.put("CD", "Конга, Дэмакратычная Рэспубліка");
    namesMap.put("CF", "Цэнтральна-Афрыканская Рэспубліка");
    namesMap.put("CG", "Конга");
    namesMap.put("CH", "Швейцарыя");
    namesMap.put("CK", "Кука астравы");
    namesMap.put("CL", "Чылі");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кітай");
    namesMap.put("CO", "Калумбія");
    namesMap.put("CR", "Коста-Рыка");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Каба-Вердэ");
    namesMap.put("CX", "Калядаў востраў");
    namesMap.put("CY", "Кіпр");
    namesMap.put("CZ", "Чэхія");
    namesMap.put("DE", "Германія");
    namesMap.put("DJ", "Джыбуці");
    namesMap.put("DK", "Данія");
    namesMap.put("DM", "Дамініка");
    namesMap.put("DO", "Дамініканская Рэспубліка");
    namesMap.put("DZ", "Алжыр");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстонія");
    namesMap.put("EG", "Егіпет");
    namesMap.put("EH", "Заходняя Сахара");
    namesMap.put("ER", "Эрытрэя");
    namesMap.put("ES", "Іспанія");
    namesMap.put("ET", "Эфіопія");
    namesMap.put("EU", "Еўрапейскі Звяз");
    namesMap.put("FI", "Фінляндыя");
    namesMap.put("FJ", "Фіджы");
    namesMap.put("FK", "Фолклэндскія астравы");
    namesMap.put("FM", "Мікранезія");
    namesMap.put("FR", "Францыя");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Велікабрытанія");
    namesMap.put("GD", "Грэнада");
    namesMap.put("GE", "Грузія");
    namesMap.put("GF", "Французская Гвіяна");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гібралтар");
    namesMap.put("GL", "Грэнландыя");
    namesMap.put("GM", "Гамбія");
    namesMap.put("GN", "Гвінея");
    namesMap.put("GP", "Гвадэлупа");
    namesMap.put("GQ", "Экватарыяльная Гвінея");
    namesMap.put("GR", "Грэцыя");
    namesMap.put("GS", "Паўднёвая Джорджыя і Паўднёвыя Сандвічавы астравы");
    namesMap.put("GT", "Гватэмала");
    namesMap.put("GW", "Гвінея-Бісаў");
    namesMap.put("GY", "Гаяна");
    namesMap.put("HK", "Гон-Конг");
    namesMap.put("HM", "Гэрда востраў і МакДоналда астравы");
    namesMap.put("HN", "Гандурас");
    namesMap.put("HR", "Харватыя");
    namesMap.put("HT", "Гаіці");
    namesMap.put("HU", "Венгрыя");
    namesMap.put("ID", "Інданезія");
    namesMap.put("IE", "Ірландыя");
    namesMap.put("IL", "Ізраіль");
    namesMap.put("IN", "Індыя");
    namesMap.put("IO", "Брытанская тэрыторыя Індыйскага акіяну");
    namesMap.put("IQ", "Ірак");
    namesMap.put("IR", "Іран, Ісламская Рэспубліка");
    namesMap.put("IS", "Ісландыя");
    namesMap.put("IT", "Італія");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Іарданія");
    namesMap.put("JP", "Японія");
    namesMap.put("KE", "Кенія");
    namesMap.put("KG", "Кыргызстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кірыбаці");
    namesMap.put("KM", "Каморскія Астравы");
    namesMap.put("KN", "Сэнт-Кітс і Нэвіс");
    namesMap.put("KP", "Паўночная Карэя");
    namesMap.put("KR", "Паўднёвая Карэя");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманавы астравы");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаоская Народна-Дэмакратычная Рэспубліка");
    namesMap.put("LB", "Ліван");
    namesMap.put("LC", "Сэнт-Люсія");
    namesMap.put("LI", "Ліхтэнштэйн");
    namesMap.put("LK", "Шры-Ланка");
    namesMap.put("LR", "Ліберыя");
    namesMap.put("LS", "Лесота");
    namesMap.put("LT", "Літва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвія");
    namesMap.put("LY", "Лівійская Арабская Джамахірыя");
    namesMap.put("MA", "Марока");
    namesMap.put("MC", "Манака");
    namesMap.put("MD", "Малдова");
    namesMap.put("ME", "Чарнагорыя");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалавы Астравы");
    namesMap.put("MK", "Македонія, БЮР");
    namesMap.put("ML", "Малі");
    namesMap.put("MM", "М'янма");
    namesMap.put("MN", "Манголія");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Паўночныя Марыянскія астравы");
    namesMap.put("MQ", "Марцініка");
    namesMap.put("MR", "Маўрытанія");
    namesMap.put("MS", "Монсэрат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маўрыкій");
    namesMap.put("MV", "Мальдыўскія Астравы");
    namesMap.put("MW", "Малаві");
    namesMap.put("MX", "Мексіка");
    namesMap.put("MY", "Малайзія");
    namesMap.put("MZ", "Мазамбік");
    namesMap.put("NA", "Намібія");
    namesMap.put("NC", "Новая Каледонія");
    namesMap.put("NE", "Нігер");
    namesMap.put("NF", "Норфалкскія астравы");
    namesMap.put("NG", "Нігерыя");
    namesMap.put("NI", "Нікарагуа");
    namesMap.put("NL", "Нідэрланды");
    namesMap.put("NO", "Нарвегія");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ніуэ");
    namesMap.put("NZ", "Новая Зеландыя");
    namesMap.put("OM", "Аман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Франузская Палінэзія");
    namesMap.put("PG", "Папуа-Новая Гвінея");
    namesMap.put("PH", "Філіпіны");
    namesMap.put("PK", "Пакістан");
    namesMap.put("PL", "Польшча");
    namesMap.put("PS", "Палестынскія тэрыторыі");
    namesMap.put("PT", "Партугалія");
    namesMap.put("PW", "Палаў");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Вонкавая Акіянія");
    namesMap.put("RE", "Рэюньён");
    namesMap.put("RO", "Румынія");
    namesMap.put("RS", "Сербія");
    namesMap.put("RU", "Расія");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудаўская Аравія");
    namesMap.put("SB", "Саламонавы Астравы");
    namesMap.put("SC", "Сейшэльскія Астравы");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швецыя");
    namesMap.put("SG", "Сінгапур");
    namesMap.put("SH", "Святой Алены, Востраў");
    namesMap.put("SI", "Славенія");
    namesMap.put("SJ", "Свальбард (Паўночна-Усходняя Зямля) і Ян-Маен");
    namesMap.put("SK", "Славакія");
    namesMap.put("SL", "Сьера-Леонэ");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Самалі");
    namesMap.put("SR", "Сурынам");
    namesMap.put("ST", "Сан-Томэ і Прынсіпі");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SY", "Сірыйская Арабская Рэспубліка");
    namesMap.put("SZ", "Свазіленд");
    namesMap.put("TC", "Тэркс і Кайкас астравы");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французскія Паўднёвыя тэрыторыі");
    namesMap.put("TG", "Тога");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Таджыкістан");
    namesMap.put("TK", "Такелаў");
    namesMap.put("TL", "Усходні Тымор");
    namesMap.put("TM", "Туркменістан");
    namesMap.put("TN", "Туніс");
    namesMap.put("TO", "Тангійская");
    namesMap.put("TR", "Турцыя");
    namesMap.put("TT", "Трынідад і Табага");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзанія, Аб'яднаная Рэспубліка");
    namesMap.put("UA", "Украіна");
    namesMap.put("UG", "Уганда");
    namesMap.put("US", "Злучаныя Штаты");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекістан");
    namesMap.put("VA", "Ватыкан");
    namesMap.put("VC", "Сэнт-Вінсэнт і Грэнадыны");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Віргінскія астравы");
    namesMap.put("VI", "Віргінскія астравы, ЗША");
    namesMap.put("VN", "В'етнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоліс і Футуна");
    namesMap.put("WS", "Самоа (Заходняе)");
    namesMap.put("YE", "Емен");
    namesMap.put("ZA", "Паўднёва-Афрыканская Рэспубліка");
    namesMap.put("ZM", "Замбія");
    namesMap.put("ZW", "Зімбабвэ");
    namesMap.put("ZZ", "Невядомы рэгіён");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Свет",
        "002": "Афрыка",
        "003": "Паўночная Амэрыка",
        "005": "Паўднёвая Амэрыка",
        "009": "Акіянія",
        "011": "Заходняя Афрыка",
        "013": "Цэнтральная Амэрыка",
        "014": "Усходняя Афрыка",
        "015": "Паўночная Афрыка",
        "017": "Цэнтральная Афрыка",
        "018": "Паўднёвая Афрыка",
        "019": "Паўночная і Паўднёвая Амерыкі",
        "021": "ЗША і Канада",
        "029": "Карыбскія астравы",
        "030": "Усходняя Азія",
        "034": "Паўднёвая Азія",
        "035": "Паўднёва-Усходняя Азія",
        "039": "Паўднёвая Еўропа",
        "053": "Аўстралія і Новая Зэландыя",
        "061": "Палінезія",
        "062": "Паўднёва-Цэнтральная Азія",
        "142": "Азія",
        "143": "Цэнтральная Азія",
        "145": "Заходняя Азія",
        "150": "Еўропа",
        "151": "Усходняя Еўропа",
        "154": "Паўночная Еўропа",
        "155": "Заходняя Еўропа",
        "172": "Садружнасць Незалежных Дзяржаў",
        "AD": "Андора",
        "AE": "Аб'яднаныя Арабскія Эміраты",
        "AF": "Афганістан",
        "AG": "Антыгуа і Барбуда",
        "AI": "Ангуілля",
        "AL": "Албанія",
        "AM": "Арменія",
        "AN": "Нідэрландскія Антылы",
        "AO": "Ангола",
        "AQ": "Антарктыка",
        "AR": "Аргенціна",
        "AS": "Амерыканскае Самоа",
        "AT": "Аўстрыя",
        "AU": "Аўстралія",
        "AW": "Аруба",
        "AX": "Аландскія астравы",
        "AZ": "Азербайджан",
        "BA": "Боснія і Герцагавіна",
        "BB": "Барбадас",
        "BD": "Бангладэш",
        "BE": "Бельгія",
        "BF": "Буркіна-Фасо",
        "BG": "Балгарыя",
        "BH": "Бахрэйн",
        "BI": "Бурундзі",
        "BJ": "Бенін",
        "BM": "Бермудскія астравы",
        "BN": "Бруней-Дарусалам",
        "BO": "Балівія",
        "BR": "Бразілія",
        "BS": "Багамскія Астравы",
        "BT": "Бутан",
        "BV": "Бувэ востраў",
        "BW": "Батсвана",
        "BY": "Беларусь",
        "BZ": "Беліз",
        "CA": "Канада",
        "CC": "Какосавыя астравы",
        "CD": "Конга, Дэмакратычная Рэспубліка",
        "CF": "Цэнтральна-Афрыканская Рэспубліка",
        "CG": "Конга",
        "CH": "Швейцарыя",
        "CK": "Кука астравы",
        "CL": "Чылі",
        "CM": "Камерун",
        "CN": "Кітай",
        "CO": "Калумбія",
        "CR": "Коста-Рыка",
        "CU": "Куба",
        "CV": "Каба-Вердэ",
        "CX": "Калядаў востраў",
        "CY": "Кіпр",
        "CZ": "Чэхія",
        "DE": "Германія",
        "DJ": "Джыбуці",
        "DK": "Данія",
        "DM": "Дамініка",
        "DO": "Дамініканская Рэспубліка",
        "DZ": "Алжыр",
        "EC": "Эквадор",
        "EE": "Эстонія",
        "EG": "Егіпет",
        "EH": "Заходняя Сахара",
        "ER": "Эрытрэя",
        "ES": "Іспанія",
        "ET": "Эфіопія",
        "EU": "Еўрапейскі Звяз",
        "FI": "Фінляндыя",
        "FJ": "Фіджы",
        "FK": "Фолклэндскія астравы",
        "FM": "Мікранезія",
        "FR": "Францыя",
        "GA": "Габон",
        "GB": "Велікабрытанія",
        "GD": "Грэнада",
        "GE": "Грузія",
        "GF": "Французская Гвіяна",
        "GH": "Гана",
        "GI": "Гібралтар",
        "GL": "Грэнландыя",
        "GM": "Гамбія",
        "GN": "Гвінея",
        "GP": "Гвадэлупа",
        "GQ": "Экватарыяльная Гвінея",
        "GR": "Грэцыя",
        "GS": "Паўднёвая Джорджыя і Паўднёвыя Сандвічавы астравы",
        "GT": "Гватэмала",
        "GW": "Гвінея-Бісаў",
        "GY": "Гаяна",
        "HK": "Гон-Конг",
        "HM": "Гэрда востраў і МакДоналда астравы",
        "HN": "Гандурас",
        "HR": "Харватыя",
        "HT": "Гаіці",
        "HU": "Венгрыя",
        "ID": "Інданезія",
        "IE": "Ірландыя",
        "IL": "Ізраіль",
        "IN": "Індыя",
        "IO": "Брытанская тэрыторыя Індыйскага акіяну",
        "IQ": "Ірак",
        "IR": "Іран, Ісламская Рэспубліка",
        "IS": "Ісландыя",
        "IT": "Італія",
        "JM": "Ямайка",
        "JO": "Іарданія",
        "JP": "Японія",
        "KE": "Кенія",
        "KG": "Кыргызстан",
        "KH": "Камбоджа",
        "KI": "Кірыбаці",
        "KM": "Каморскія Астравы",
        "KN": "Сэнт-Кітс і Нэвіс",
        "KP": "Паўночная Карэя",
        "KR": "Паўднёвая Карэя",
        "KW": "Кувейт",
        "KY": "Кайманавы астравы",
        "KZ": "Казахстан",
        "LA": "Лаоская Народна-Дэмакратычная Рэспубліка",
        "LB": "Ліван",
        "LC": "Сэнт-Люсія",
        "LI": "Ліхтэнштэйн",
        "LK": "Шры-Ланка",
        "LR": "Ліберыя",
        "LS": "Лесота",
        "LT": "Літва",
        "LU": "Люксембург",
        "LV": "Латвія",
        "LY": "Лівійская Арабская Джамахірыя",
        "MA": "Марока",
        "MC": "Манака",
        "MD": "Малдова",
        "ME": "Чарнагорыя",
        "MG": "Мадагаскар",
        "MH": "Маршалавы Астравы",
        "MK": "Македонія, БЮР",
        "ML": "Малі",
        "MM": "М'янма",
        "MN": "Манголія",
        "MO": "Макао",
        "MP": "Паўночныя Марыянскія астравы",
        "MQ": "Марцініка",
        "MR": "Маўрытанія",
        "MS": "Монсэрат",
        "MT": "Мальта",
        "MU": "Маўрыкій",
        "MV": "Мальдыўскія Астравы",
        "MW": "Малаві",
        "MX": "Мексіка",
        "MY": "Малайзія",
        "MZ": "Мазамбік",
        "NA": "Намібія",
        "NC": "Новая Каледонія",
        "NE": "Нігер",
        "NF": "Норфалкскія астравы",
        "NG": "Нігерыя",
        "NI": "Нікарагуа",
        "NL": "Нідэрланды",
        "NO": "Нарвегія",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ніуэ",
        "NZ": "Новая Зеландыя",
        "OM": "Аман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Франузская Палінэзія",
        "PG": "Папуа-Новая Гвінея",
        "PH": "Філіпіны",
        "PK": "Пакістан",
        "PL": "Польшча",
        "PS": "Палестынскія тэрыторыі",
        "PT": "Партугалія",
        "PW": "Палаў",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Вонкавая Акіянія",
        "RE": "Рэюньён",
        "RO": "Румынія",
        "RS": "Сербія",
        "RU": "Расія",
        "RW": "Руанда",
        "SA": "Саудаўская Аравія",
        "SB": "Саламонавы Астравы",
        "SC": "Сейшэльскія Астравы",
        "SD": "Судан",
        "SE": "Швецыя",
        "SG": "Сінгапур",
        "SH": "Святой Алены, Востраў",
        "SI": "Славенія",
        "SJ": "Свальбард (Паўночна-Усходняя Зямля) і Ян-Маен",
        "SK": "Славакія",
        "SL": "Сьера-Леонэ",
        "SN": "Сенегал",
        "SO": "Самалі",
        "SR": "Сурынам",
        "ST": "Сан-Томэ і Прынсіпі",
        "SV": "Сальвадор",
        "SY": "Сірыйская Арабская Рэспубліка",
        "SZ": "Свазіленд",
        "TC": "Тэркс і Кайкас астравы",
        "TD": "Чад",
        "TF": "Французскія Паўднёвыя тэрыторыі",
        "TG": "Тога",
        "TH": "Тайланд",
        "TJ": "Таджыкістан",
        "TK": "Такелаў",
        "TL": "Усходні Тымор",
        "TM": "Туркменістан",
        "TN": "Туніс",
        "TO": "Тангійская",
        "TR": "Турцыя",
        "TT": "Трынідад і Табага",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзанія, Аб'яднаная Рэспубліка",
        "UA": "Украіна",
        "UG": "Уганда",
        "US": "Злучаныя Штаты",
        "UY": "Уругвай",
        "UZ": "Узбекістан",
        "VA": "Ватыкан",
        "VC": "Сэнт-Вінсэнт і Грэнадыны",
        "VE": "Венесуэла",
        "VG": "Віргінскія астравы",
        "VI": "Віргінскія астравы, ЗША",
        "VN": "В'етнам",
        "VU": "Вануату",
        "WF": "Уоліс і Футуна",
        "WS": "Самоа (Заходняе)",
        "YE": "Емен",
        "ZA": "Паўднёва-Афрыканская Рэспубліка",
        "ZM": "Замбія",
        "ZW": "Зімбабвэ",
        "ZZ": "Невядомы рэгіён"
    };
  }-*/;
}
