/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private final Arguments args;
    private JavaCompiler compiler;
    private Locale locale;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private boolean parsed = false;

    JavacTaskImpl(Context context) {
        super(context, true);
        this.args = Arguments.instance(context);
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Main.Result doCall() {
        try {
            Main.Result result = this.handleExceptions(new Callable<Main.Result>(){

                @Override
                public Main.Result call() throws Exception {
                    JavacTaskImpl.this.prepareCompiler(false);
                    JavacTaskImpl.this.compiler.compile(JavacTaskImpl.this.args.getFileObjects(), JavacTaskImpl.this.args.getClassNames(), JavacTaskImpl.this.processors);
                    return JavacTaskImpl.this.compiler.errorCount() > 0 ? Main.Result.ERROR : Main.Result.OK;
                }
            }, Main.Result.SYSERR, Main.Result.ABNORMAL);
            return result;
        }
        finally {
            try {
                this.cleanup();
            }
            catch (ClientCodeException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        processors.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    private <T> T handleExceptions(Callable<T> c, T sysErrorResult, T abnormalErrorResult) {
        try {
            return c.call();
        }
        catch (FatalError ex) {
            Log log = Log.instance(this.context);
            Options options = Options.instance(this.context);
            log.printRawLines(ex.getMessage());
            if (ex.getCause() != null && options.isSet("dev")) {
                ex.getCause().printStackTrace(log.getWriter(Log.WriterKind.NOTICE));
            }
            return sysErrorResult;
        }
        catch (AnnotationProcessingError | ClientCodeException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (PropagatedException e) {
            throw e.getCause();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Error | Exception ex) {
            if (this.compiler == null || this.compiler.errorCount() == 0 || Options.instance(this.context).isSet("dev")) {
                Log log = Log.instance(this.context);
                log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
                ex.printStackTrace(log.getWriter(Log.WriterKind.NOTICE));
            }
            return abnormalErrorResult;
        }
    }

    private void prepareCompiler(boolean forParse) {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new PropagatedException(new IllegalStateException());
            }
        } else {
            this.args.validate();
            this.context.put(Locale.class, this.locale);
            JavacMessages messages = this.context.get(JavacMessages.messagesKey);
            if (messages != null && !messages.getCurrentLocale().equals(this.locale)) {
                messages.setCurrentLocale(this.locale);
            }
            this.initPlugins(this.args.getPluginOpts());
            this.initDocLint(this.args.getDocLintOpts());
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            if (forParse) {
                this.compiler.initProcessAnnotations(this.processors);
                for (JavaFileObject file : this.args.getFileObjects()) {
                    this.notYetEntered.put(file, null);
                }
                this.genList = new ListBuffer();
            }
        }
    }

    <T> String toString(Iterable<T> items, String sep) {
        String currSep = "";
        StringBuilder sb = new StringBuilder();
        for (T item : items) {
            sb.append(currSep);
            sb.append(item.toString());
            currSep = sep;
        }
        return sb.toString();
    }

    void cleanup() {
        if (this.compiler != null) {
            this.compiler.close();
        }
        this.compiler = null;
        this.context = null;
        this.notYetEntered = null;
    }

    @Override
    public Iterable<? extends CompilationUnitTree> parse() {
        return this.handleExceptions(new Callable<Iterable<? extends CompilationUnitTree>>(){

            @Override
            public Iterable<? extends CompilationUnitTree> call() {
                return JavacTaskImpl.this.parseInternal();
            }
        }, List.nil(), List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends CompilationUnitTree> parseInternal() {
        try {
            this.prepareCompiler(true);
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.args.getFileObjects());
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends TypeElement> enter() {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> trees) {
        if (trees == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        this.prepareCompiler(true);
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parseInternal();
                }
                for (JavaFileObject javaFileObject : this.args.getFileObjects()) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            return List.nil();
        }
        try {
            List<JCTree.JCCompilationUnit> units = this.compiler.enterTrees(roots.toList());
            if (this.notYetEntered.isEmpty()) {
                this.compiler.processAnnotations(units);
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                for (JCTree node : unit.defs) {
                    if (!node.hasTag(JCTree.Tag.CLASSDEF)) continue;
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)node;
                    if (cdef.sym == null) continue;
                    listBuffer.append(cdef.sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() {
        return this.handleExceptions(new Callable<Iterable<? extends Element>>(){

            @Override
            public Iterable<? extends Element> call() {
                return JavacTaskImpl.this.analyze(null);
            }
        }, List.nil(), List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> classes) {
        this.enter(null);
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> elems) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case TOPLEVEL: {
                    JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)env.tree;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() {
        return this.handleExceptions(new Callable<Iterable<? extends JavaFileObject>>(){

            @Override
            public Iterable<? extends JavaFileObject> call() {
                return JavacTaskImpl.this.generate(null);
            }
        }, List.nil(), List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> classes) {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.cleanup();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.flush();
            }
        }
        return results;
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree unit, Tree node) {
        return TreeInfo.pathFor((JCTree)node, (JCTree.JCCompilationUnit)unit).reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer buf = CharBuffer.wrap(String.valueOf(expr).concat("\u0000").toCharArray(), 0, expr.length());
            JavacParser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression tree = parser.parseType();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> list, Iterable<? extends TypeElement> classes) {
            HashSet<TypeElement> set = new HashSet<TypeElement>();
            for (TypeElement typeElement : classes) {
                set.add(typeElement);
            }
            ListBuffer<Env<AttrContext>> defer = new ListBuffer<Env<AttrContext>>();
            while (list.peek() != null) {
                Env<AttrContext> env = list.remove();
                Symbol.ClassSymbol csym = env.enclClass.sym;
                if (csym != null && set.contains(csym.outermostClass())) {
                    this.process(env);
                    continue;
                }
                defer = defer.append(env);
            }
            list.addAll(defer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

