/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataLoader;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.secretmanager.SecretManagerServiceClientFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DefaultSecretManagerServiceClientFactory
implements SecretManagerServiceClientFactory {
    private final CredentialsProvider credentialsProvider;
    private final Map<String, SecretManagerServiceClient> clientCache = new ConcurrentHashMap<String, SecretManagerServiceClient>();

    DefaultSecretManagerServiceClientFactory(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public SecretManagerServiceClient getClient(@Nullable String location) {
        if (ObjectUtils.isEmpty((Object)location)) {
            location = "global";
        }
        return this.clientCache.computeIfAbsent(location, loc -> {
            try {
                SecretManagerServiceSettings.Builder settings = (SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(SecretManagerConfigDataLoader.class));
                if (!loc.equals("global")) {
                    settings.setEndpoint(String.format("secretmanager.%s.rep.googleapis.com:443", loc));
                }
                return SecretManagerServiceClient.create((SecretManagerServiceSettings)settings.build());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create SecretManagerServiceClient for location: " + loc, e);
            }
        });
    }
}

