package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TableResult extends TableResult {

  @Nullable
  private final Schema schema;

  private final long totalRows;

  private final Page<FieldValueList> pageNoSchema;

  @Nullable
  private final JobId jobId;

  @Nullable
  private final String queryId;

  private AutoValue_TableResult(
      @Nullable Schema schema,
      long totalRows,
      Page<FieldValueList> pageNoSchema,
      @Nullable JobId jobId,
      @Nullable String queryId) {
    this.schema = schema;
    this.totalRows = totalRows;
    this.pageNoSchema = pageNoSchema;
    this.jobId = jobId;
    this.queryId = queryId;
  }

  @Nullable
  @Override
  public Schema getSchema() {
    return schema;
  }

  @Override
  public long getTotalRows() {
    return totalRows;
  }

  @Override
  public Page<FieldValueList> getPageNoSchema() {
    return pageNoSchema;
  }

  @Nullable
  @Override
  public JobId getJobId() {
    return jobId;
  }

  @Nullable
  @Override
  public String getQueryId() {
    return queryId;
  }

  private static final long serialVersionUID = 1L;

  @Override
  public TableResult.Builder toBuilder() {
    return new AutoValue_TableResult.Builder(this);
  }

  static final class Builder extends TableResult.Builder {
    private Schema schema;
    private long totalRows;
    private Page<FieldValueList> pageNoSchema;
    private JobId jobId;
    private String queryId;
    private byte set$0;
    Builder() {
    }
    Builder(TableResult source) {
      this.schema = source.getSchema();
      this.totalRows = source.getTotalRows();
      this.pageNoSchema = source.getPageNoSchema();
      this.jobId = source.getJobId();
      this.queryId = source.getQueryId();
      set$0 = (byte) 1;
    }
    @Override
    public TableResult.Builder setSchema(Schema schema) {
      this.schema = schema;
      return this;
    }
    @Override
    public TableResult.Builder setTotalRows(Long totalRows) {
      if (totalRows == null) {
        throw new NullPointerException("Null totalRows");
      }
      this.totalRows = totalRows;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public TableResult.Builder setPageNoSchema(Page<FieldValueList> pageNoSchema) {
      if (pageNoSchema == null) {
        throw new NullPointerException("Null pageNoSchema");
      }
      this.pageNoSchema = pageNoSchema;
      return this;
    }
    @Override
    public TableResult.Builder setJobId(JobId jobId) {
      this.jobId = jobId;
      return this;
    }
    @Override
    public TableResult.Builder setQueryId(String queryId) {
      this.queryId = queryId;
      return this;
    }
    @Override
    public TableResult build() {
      if (set$0 != 1
          || this.pageNoSchema == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" totalRows");
        }
        if (this.pageNoSchema == null) {
          missing.append(" pageNoSchema");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TableResult(
          this.schema,
          this.totalRows,
          this.pageNoSchema,
          this.jobId,
          this.queryId);
    }
  }

}
