/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/volume.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * Volume describes a volume and parameters for it to be mounted to a VM.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.Volume}
 */
public final class Volume extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.Volume)
    VolumeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Volume.newBuilder() to construct.
  private Volume(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Volume() {
    mountPath_ = "";
    mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Volume();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.VolumeProto
        .internal_static_google_cloud_batch_v1_Volume_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.VolumeProto
        .internal_static_google_cloud_batch_v1_Volume_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.Volume.class, com.google.cloud.batch.v1.Volume.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NFS(1),
    GCS(3),
    DEVICE_NAME(6),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return NFS;
        case 3:
          return GCS;
        case 6:
          return DEVICE_NAME;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int NFS_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * A Network File System (NFS) volume. For example, a
   * Filestore file share.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
   *
   * @return Whether the nfs field is set.
   */
  @java.lang.Override
  public boolean hasNfs() {
    return sourceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * A Network File System (NFS) volume. For example, a
   * Filestore file share.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
   *
   * @return The nfs.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.NFS getNfs() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.batch.v1.NFS) source_;
    }
    return com.google.cloud.batch.v1.NFS.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * A Network File System (NFS) volume. For example, a
   * Filestore file share.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.NFSOrBuilder getNfsOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.cloud.batch.v1.NFS) source_;
    }
    return com.google.cloud.batch.v1.NFS.getDefaultInstance();
  }

  public static final int GCS_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * A Google Cloud Storage (GCS) volume.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
   *
   * @return Whether the gcs field is set.
   */
  @java.lang.Override
  public boolean hasGcs() {
    return sourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * A Google Cloud Storage (GCS) volume.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
   *
   * @return The gcs.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.GCS getGcs() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.batch.v1.GCS) source_;
    }
    return com.google.cloud.batch.v1.GCS.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * A Google Cloud Storage (GCS) volume.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.GCSOrBuilder getGcsOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.batch.v1.GCS) source_;
    }
    return com.google.cloud.batch.v1.GCS.getDefaultInstance();
  }

  public static final int DEVICE_NAME_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Device name of an attached disk volume, which should align with a
   * device_name specified by
   * job.allocation_policy.instances[0].policy.disks[i].device_name or
   * defined by the given instance template in
   * job.allocation_policy.instances[0].instance_template.
   * </pre>
   *
   * <code>string device_name = 6;</code>
   *
   * @return Whether the deviceName field is set.
   */
  public boolean hasDeviceName() {
    return sourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Device name of an attached disk volume, which should align with a
   * device_name specified by
   * job.allocation_policy.instances[0].policy.disks[i].device_name or
   * defined by the given instance template in
   * job.allocation_policy.instances[0].instance_template.
   * </pre>
   *
   * <code>string device_name = 6;</code>
   *
   * @return The deviceName.
   */
  public java.lang.String getDeviceName() {
    java.lang.Object ref = "";
    if (sourceCase_ == 6) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 6) {
        source_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Device name of an attached disk volume, which should align with a
   * device_name specified by
   * job.allocation_policy.instances[0].policy.disks[i].device_name or
   * defined by the given instance template in
   * job.allocation_policy.instances[0].instance_template.
   * </pre>
   *
   * <code>string device_name = 6;</code>
   *
   * @return The bytes for deviceName.
   */
  public com.google.protobuf.ByteString getDeviceNameBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 6) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 6) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MOUNT_PATH_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mountPath_ = "";

  /**
   *
   *
   * <pre>
   * The mount path for the volume, e.g. /mnt/disks/share.
   * </pre>
   *
   * <code>string mount_path = 4;</code>
   *
   * @return The mountPath.
   */
  @java.lang.Override
  public java.lang.String getMountPath() {
    java.lang.Object ref = mountPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mountPath_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The mount path for the volume, e.g. /mnt/disks/share.
   * </pre>
   *
   * <code>string mount_path = 4;</code>
   *
   * @return The bytes for mountPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMountPathBytes() {
    java.lang.Object ref = mountPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mountPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MOUNT_OPTIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList mountOptions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Mount options vary based on the type of storage volume:
   *
   * * For a Cloud Storage bucket, all the mount options provided
   * by
   *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
   *   are supported.
   * * For an existing persistent disk, all mount options provided by the
   *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
   *   except writing are supported. This is due to restrictions of
   *   [multi-writer
   *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
   * * For any other disk or a Network File System (NFS), all the
   *   mount options provided by the `mount` command are supported.
   * </pre>
   *
   * <code>repeated string mount_options = 5;</code>
   *
   * @return A list containing the mountOptions.
   */
  public com.google.protobuf.ProtocolStringList getMountOptionsList() {
    return mountOptions_;
  }

  /**
   *
   *
   * <pre>
   * Mount options vary based on the type of storage volume:
   *
   * * For a Cloud Storage bucket, all the mount options provided
   * by
   *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
   *   are supported.
   * * For an existing persistent disk, all mount options provided by the
   *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
   *   except writing are supported. This is due to restrictions of
   *   [multi-writer
   *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
   * * For any other disk or a Network File System (NFS), all the
   *   mount options provided by the `mount` command are supported.
   * </pre>
   *
   * <code>repeated string mount_options = 5;</code>
   *
   * @return The count of mountOptions.
   */
  public int getMountOptionsCount() {
    return mountOptions_.size();
  }

  /**
   *
   *
   * <pre>
   * Mount options vary based on the type of storage volume:
   *
   * * For a Cloud Storage bucket, all the mount options provided
   * by
   *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
   *   are supported.
   * * For an existing persistent disk, all mount options provided by the
   *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
   *   except writing are supported. This is due to restrictions of
   *   [multi-writer
   *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
   * * For any other disk or a Network File System (NFS), all the
   *   mount options provided by the `mount` command are supported.
   * </pre>
   *
   * <code>repeated string mount_options = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The mountOptions at the given index.
   */
  public java.lang.String getMountOptions(int index) {
    return mountOptions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Mount options vary based on the type of storage volume:
   *
   * * For a Cloud Storage bucket, all the mount options provided
   * by
   *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
   *   are supported.
   * * For an existing persistent disk, all mount options provided by the
   *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
   *   except writing are supported. This is due to restrictions of
   *   [multi-writer
   *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
   * * For any other disk or a Network File System (NFS), all the
   *   mount options provided by the `mount` command are supported.
   * </pre>
   *
   * <code>repeated string mount_options = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the mountOptions at the given index.
   */
  public com.google.protobuf.ByteString getMountOptionsBytes(int index) {
    return mountOptions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.batch.v1.NFS) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.batch.v1.GCS) source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, mountPath_);
    }
    for (int i = 0; i < mountOptions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, mountOptions_.getRaw(i));
    }
    if (sourceCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.batch.v1.NFS) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.batch.v1.GCS) source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, mountPath_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < mountOptions_.size(); i++) {
        dataSize += computeStringSizeNoTag(mountOptions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMountOptionsList().size();
    }
    if (sourceCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.Volume)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.Volume other = (com.google.cloud.batch.v1.Volume) obj;

    if (!getMountPath().equals(other.getMountPath())) return false;
    if (!getMountOptionsList().equals(other.getMountOptionsList())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getNfs().equals(other.getNfs())) return false;
        break;
      case 3:
        if (!getGcs().equals(other.getGcs())) return false;
        break;
      case 6:
        if (!getDeviceName().equals(other.getDeviceName())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MOUNT_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getMountPath().hashCode();
    if (getMountOptionsCount() > 0) {
      hash = (37 * hash) + MOUNT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMountOptionsList().hashCode();
    }
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + NFS_FIELD_NUMBER;
        hash = (53 * hash) + getNfs().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_FIELD_NUMBER;
        hash = (53 * hash) + getGcs().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DEVICE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDeviceName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Volume parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Volume parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Volume parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.Volume prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Volume describes a volume and parameters for it to be mounted to a VM.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.Volume}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.Volume)
      com.google.cloud.batch.v1.VolumeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.VolumeProto
          .internal_static_google_cloud_batch_v1_Volume_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.VolumeProto
          .internal_static_google_cloud_batch_v1_Volume_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.Volume.class,
              com.google.cloud.batch.v1.Volume.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.Volume.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (nfsBuilder_ != null) {
        nfsBuilder_.clear();
      }
      if (gcsBuilder_ != null) {
        gcsBuilder_.clear();
      }
      mountPath_ = "";
      mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.VolumeProto
          .internal_static_google_cloud_batch_v1_Volume_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Volume getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.Volume.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Volume build() {
      com.google.cloud.batch.v1.Volume result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Volume buildPartial() {
      com.google.cloud.batch.v1.Volume result = new com.google.cloud.batch.v1.Volume(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1.Volume result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mountPath_ = mountPath_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        mountOptions_.makeImmutable();
        result.mountOptions_ = mountOptions_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.batch.v1.Volume result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && nfsBuilder_ != null) {
        result.source_ = nfsBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsBuilder_ != null) {
        result.source_ = gcsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.Volume) {
        return mergeFrom((com.google.cloud.batch.v1.Volume) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.Volume other) {
      if (other == com.google.cloud.batch.v1.Volume.getDefaultInstance()) return this;
      if (!other.getMountPath().isEmpty()) {
        mountPath_ = other.mountPath_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.mountOptions_.isEmpty()) {
        if (mountOptions_.isEmpty()) {
          mountOptions_ = other.mountOptions_;
          bitField0_ |= 0x00000010;
        } else {
          ensureMountOptionsIsMutable();
          mountOptions_.addAll(other.mountOptions_);
        }
        onChanged();
      }
      switch (other.getSourceCase()) {
        case NFS:
          {
            mergeNfs(other.getNfs());
            break;
          }
        case GCS:
          {
            mergeGcs(other.getGcs());
            break;
          }
        case DEVICE_NAME:
          {
            sourceCase_ = 6;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getNfsFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getGcsFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                mountPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMountOptionsIsMutable();
                mountOptions_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 6;
                source_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.NFS,
            com.google.cloud.batch.v1.NFS.Builder,
            com.google.cloud.batch.v1.NFSOrBuilder>
        nfsBuilder_;

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     *
     * @return Whether the nfs field is set.
     */
    @java.lang.Override
    public boolean hasNfs() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     *
     * @return The nfs.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.NFS getNfs() {
      if (nfsBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.cloud.batch.v1.NFS) source_;
        }
        return com.google.cloud.batch.v1.NFS.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return nfsBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1.NFS.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    public Builder setNfs(com.google.cloud.batch.v1.NFS value) {
      if (nfsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        nfsBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    public Builder setNfs(com.google.cloud.batch.v1.NFS.Builder builderForValue) {
      if (nfsBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        nfsBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    public Builder mergeNfs(com.google.cloud.batch.v1.NFS value) {
      if (nfsBuilder_ == null) {
        if (sourceCase_ == 1 && source_ != com.google.cloud.batch.v1.NFS.getDefaultInstance()) {
          source_ =
              com.google
                  .cloud
                  .batch
                  .v1
                  .NFS
                  .newBuilder((com.google.cloud.batch.v1.NFS) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          nfsBuilder_.mergeFrom(value);
        } else {
          nfsBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    public Builder clearNfs() {
      if (nfsBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        nfsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    public com.google.cloud.batch.v1.NFS.Builder getNfsBuilder() {
      return getNfsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.NFSOrBuilder getNfsOrBuilder() {
      if ((sourceCase_ == 1) && (nfsBuilder_ != null)) {
        return nfsBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.cloud.batch.v1.NFS) source_;
        }
        return com.google.cloud.batch.v1.NFS.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A Network File System (NFS) volume. For example, a
     * Filestore file share.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.NFS nfs = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.NFS,
            com.google.cloud.batch.v1.NFS.Builder,
            com.google.cloud.batch.v1.NFSOrBuilder>
        getNfsFieldBuilder() {
      if (nfsBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ = com.google.cloud.batch.v1.NFS.getDefaultInstance();
        }
        nfsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.NFS,
                com.google.cloud.batch.v1.NFS.Builder,
                com.google.cloud.batch.v1.NFSOrBuilder>(
                (com.google.cloud.batch.v1.NFS) source_, getParentForChildren(), isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return nfsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.GCS,
            com.google.cloud.batch.v1.GCS.Builder,
            com.google.cloud.batch.v1.GCSOrBuilder>
        gcsBuilder_;

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     *
     * @return Whether the gcs field is set.
     */
    @java.lang.Override
    public boolean hasGcs() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     *
     * @return The gcs.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.GCS getGcs() {
      if (gcsBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.batch.v1.GCS) source_;
        }
        return com.google.cloud.batch.v1.GCS.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1.GCS.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    public Builder setGcs(com.google.cloud.batch.v1.GCS value) {
      if (gcsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    public Builder setGcs(com.google.cloud.batch.v1.GCS.Builder builderForValue) {
      if (gcsBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    public Builder mergeGcs(com.google.cloud.batch.v1.GCS value) {
      if (gcsBuilder_ == null) {
        if (sourceCase_ == 3 && source_ != com.google.cloud.batch.v1.GCS.getDefaultInstance()) {
          source_ =
              com.google
                  .cloud
                  .batch
                  .v1
                  .GCS
                  .newBuilder((com.google.cloud.batch.v1.GCS) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsBuilder_.mergeFrom(value);
        } else {
          gcsBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    public Builder clearGcs() {
      if (gcsBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    public com.google.cloud.batch.v1.GCS.Builder getGcsBuilder() {
      return getGcsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.GCSOrBuilder getGcsOrBuilder() {
      if ((sourceCase_ == 3) && (gcsBuilder_ != null)) {
        return gcsBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.batch.v1.GCS) source_;
        }
        return com.google.cloud.batch.v1.GCS.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A Google Cloud Storage (GCS) volume.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.GCS gcs = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.GCS,
            com.google.cloud.batch.v1.GCS.Builder,
            com.google.cloud.batch.v1.GCSOrBuilder>
        getGcsFieldBuilder() {
      if (gcsBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.batch.v1.GCS.getDefaultInstance();
        }
        gcsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.GCS,
                com.google.cloud.batch.v1.GCS.Builder,
                com.google.cloud.batch.v1.GCSOrBuilder>(
                (com.google.cloud.batch.v1.GCS) source_, getParentForChildren(), isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @return Whether the deviceName field is set.
     */
    @java.lang.Override
    public boolean hasDeviceName() {
      return sourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @return The deviceName.
     */
    @java.lang.Override
    public java.lang.String getDeviceName() {
      java.lang.Object ref = "";
      if (sourceCase_ == 6) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 6) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @return The bytes for deviceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDeviceNameBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 6) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 6) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @param value The deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 6;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeviceName() {
      if (sourceCase_ == 6) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Device name of an attached disk volume, which should align with a
     * device_name specified by
     * job.allocation_policy.instances[0].policy.disks[i].device_name or
     * defined by the given instance template in
     * job.allocation_policy.instances[0].instance_template.
     * </pre>
     *
     * <code>string device_name = 6;</code>
     *
     * @param value The bytes for deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 6;
      source_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object mountPath_ = "";

    /**
     *
     *
     * <pre>
     * The mount path for the volume, e.g. /mnt/disks/share.
     * </pre>
     *
     * <code>string mount_path = 4;</code>
     *
     * @return The mountPath.
     */
    public java.lang.String getMountPath() {
      java.lang.Object ref = mountPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mountPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The mount path for the volume, e.g. /mnt/disks/share.
     * </pre>
     *
     * <code>string mount_path = 4;</code>
     *
     * @return The bytes for mountPath.
     */
    public com.google.protobuf.ByteString getMountPathBytes() {
      java.lang.Object ref = mountPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mountPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The mount path for the volume, e.g. /mnt/disks/share.
     * </pre>
     *
     * <code>string mount_path = 4;</code>
     *
     * @param value The mountPath to set.
     * @return This builder for chaining.
     */
    public Builder setMountPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mountPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mount path for the volume, e.g. /mnt/disks/share.
     * </pre>
     *
     * <code>string mount_path = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMountPath() {
      mountPath_ = getDefaultInstance().getMountPath();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mount path for the volume, e.g. /mnt/disks/share.
     * </pre>
     *
     * <code>string mount_path = 4;</code>
     *
     * @param value The bytes for mountPath to set.
     * @return This builder for chaining.
     */
    public Builder setMountPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mountPath_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList mountOptions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMountOptionsIsMutable() {
      if (!mountOptions_.isModifiable()) {
        mountOptions_ = new com.google.protobuf.LazyStringArrayList(mountOptions_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @return A list containing the mountOptions.
     */
    public com.google.protobuf.ProtocolStringList getMountOptionsList() {
      mountOptions_.makeImmutable();
      return mountOptions_;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @return The count of mountOptions.
     */
    public int getMountOptionsCount() {
      return mountOptions_.size();
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The mountOptions at the given index.
     */
    public java.lang.String getMountOptions(int index) {
      return mountOptions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the mountOptions at the given index.
     */
    public com.google.protobuf.ByteString getMountOptionsBytes(int index) {
      return mountOptions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The mountOptions to set.
     * @return This builder for chaining.
     */
    public Builder setMountOptions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMountOptionsIsMutable();
      mountOptions_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param value The mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addMountOptions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMountOptionsIsMutable();
      mountOptions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param values The mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllMountOptions(java.lang.Iterable<java.lang.String> values) {
      ensureMountOptionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mountOptions_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMountOptions() {
      mountOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Mount options vary based on the type of storage volume:
     *
     * * For a Cloud Storage bucket, all the mount options provided
     * by
     *   the [`gcsfuse` tool](https://cloud.google.com/storage/docs/gcsfuse-cli)
     *   are supported.
     * * For an existing persistent disk, all mount options provided by the
     *   [`mount` command](https://man7.org/linux/man-pages/man8/mount.8.html)
     *   except writing are supported. This is due to restrictions of
     *   [multi-writer
     *   mode](https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms).
     * * For any other disk or a Network File System (NFS), all the
     *   mount options provided by the `mount` command are supported.
     * </pre>
     *
     * <code>repeated string mount_options = 5;</code>
     *
     * @param value The bytes of the mountOptions to add.
     * @return This builder for chaining.
     */
    public Builder addMountOptionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMountOptionsIsMutable();
      mountOptions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.Volume)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.Volume)
  private static final com.google.cloud.batch.v1.Volume DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.Volume();
  }

  public static com.google.cloud.batch.v1.Volume getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Volume> PARSER =
      new com.google.protobuf.AbstractParser<Volume>() {
        @java.lang.Override
        public Volume parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Volume> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Volume> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.Volume getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
