/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * A TaskGroup defines one or more Tasks that all share the same TaskSpec.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.TaskGroup}
 */
public final class TaskGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.TaskGroup)
    TaskGroupOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TaskGroup.newBuilder() to construct.
  private TaskGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TaskGroup() {
    name_ = "";
    schedulingPolicy_ = 0;
    taskEnvironments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TaskGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.JobProto
        .internal_static_google_cloud_batch_v1_TaskGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.JobProto
        .internal_static_google_cloud_batch_v1_TaskGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.TaskGroup.class,
            com.google.cloud.batch.v1.TaskGroup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * How Tasks in the TaskGroup should be scheduled relative to each other.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1.TaskGroup.SchedulingPolicy}
   */
  public enum SchedulingPolicy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SCHEDULING_POLICY_UNSPECIFIED = 0;</code>
     */
    SCHEDULING_POLICY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Run Tasks as soon as resources are available.
     *
     * Tasks might be executed in parallel depending on parallelism and
     * task_count values.
     * </pre>
     *
     * <code>AS_SOON_AS_POSSIBLE = 1;</code>
     */
    AS_SOON_AS_POSSIBLE(1),
    /**
     *
     *
     * <pre>
     * Run Tasks sequentially with increased task index.
     * </pre>
     *
     * <code>IN_ORDER = 2;</code>
     */
    IN_ORDER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SCHEDULING_POLICY_UNSPECIFIED = 0;</code>
     */
    public static final int SCHEDULING_POLICY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Run Tasks as soon as resources are available.
     *
     * Tasks might be executed in parallel depending on parallelism and
     * task_count values.
     * </pre>
     *
     * <code>AS_SOON_AS_POSSIBLE = 1;</code>
     */
    public static final int AS_SOON_AS_POSSIBLE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Run Tasks sequentially with increased task index.
     * </pre>
     *
     * <code>IN_ORDER = 2;</code>
     */
    public static final int IN_ORDER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchedulingPolicy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SchedulingPolicy forNumber(int value) {
      switch (value) {
        case 0:
          return SCHEDULING_POLICY_UNSPECIFIED;
        case 1:
          return AS_SOON_AS_POSSIBLE;
        case 2:
          return IN_ORDER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SchedulingPolicy> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SchedulingPolicy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SchedulingPolicy>() {
              public SchedulingPolicy findValueByNumber(int number) {
                return SchedulingPolicy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskGroup.getDescriptor().getEnumTypes().get(0);
    }

    private static final SchedulingPolicy[] VALUES = values();

    public static SchedulingPolicy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SchedulingPolicy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1.TaskGroup.SchedulingPolicy)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. TaskGroup name.
   * The system generates this field based on parent Job name.
   * For example:
   * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. TaskGroup name.
   * The system generates this field based on parent Job name.
   * For example:
   * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TASK_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.batch.v1.TaskSpec taskSpec_;

  /**
   *
   *
   * <pre>
   * Required. Tasks in the group share the same task spec.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the taskSpec field is set.
   */
  @java.lang.Override
  public boolean hasTaskSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Tasks in the group share the same task spec.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The taskSpec.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.TaskSpec getTaskSpec() {
    return taskSpec_ == null ? com.google.cloud.batch.v1.TaskSpec.getDefaultInstance() : taskSpec_;
  }

  /**
   *
   *
   * <pre>
   * Required. Tasks in the group share the same task spec.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.TaskSpecOrBuilder getTaskSpecOrBuilder() {
    return taskSpec_ == null ? com.google.cloud.batch.v1.TaskSpec.getDefaultInstance() : taskSpec_;
  }

  public static final int TASK_COUNT_FIELD_NUMBER = 4;
  private long taskCount_ = 0L;

  /**
   *
   *
   * <pre>
   * Number of Tasks in the TaskGroup.
   * Default is 1.
   * </pre>
   *
   * <code>int64 task_count = 4;</code>
   *
   * @return The taskCount.
   */
  @java.lang.Override
  public long getTaskCount() {
    return taskCount_;
  }

  public static final int PARALLELISM_FIELD_NUMBER = 5;
  private long parallelism_ = 0L;

  /**
   *
   *
   * <pre>
   * Max number of tasks that can run in parallel.
   * Default to min(task_count, parallel tasks per job limit).
   * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
   * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
   * </pre>
   *
   * <code>int64 parallelism = 5;</code>
   *
   * @return The parallelism.
   */
  @java.lang.Override
  public long getParallelism() {
    return parallelism_;
  }

  public static final int SCHEDULING_POLICY_FIELD_NUMBER = 6;
  private int schedulingPolicy_ = 0;

  /**
   *
   *
   * <pre>
   * Scheduling policy for Tasks in the TaskGroup.
   * The default value is AS_SOON_AS_POSSIBLE.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
   *
   * @return The enum numeric value on the wire for schedulingPolicy.
   */
  @java.lang.Override
  public int getSchedulingPolicyValue() {
    return schedulingPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Scheduling policy for Tasks in the TaskGroup.
   * The default value is AS_SOON_AS_POSSIBLE.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
   *
   * @return The schedulingPolicy.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy getSchedulingPolicy() {
    com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy result =
        com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.forNumber(schedulingPolicy_);
    return result == null
        ? com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.UNRECOGNIZED
        : result;
  }

  public static final int TASK_ENVIRONMENTS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.Environment> taskEnvironments_;

  /**
   *
   *
   * <pre>
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should
   * not be specified in the request (and will be ignored). Task count will be
   * the length of task_environments.
   *
   * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
   * addition to any environment variables set in task_environments, specifying
   * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
   * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.Environment> getTaskEnvironmentsList() {
    return taskEnvironments_;
  }

  /**
   *
   *
   * <pre>
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should
   * not be specified in the request (and will be ignored). Task count will be
   * the length of task_environments.
   *
   * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
   * addition to any environment variables set in task_environments, specifying
   * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
   * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.EnvironmentOrBuilder>
      getTaskEnvironmentsOrBuilderList() {
    return taskEnvironments_;
  }

  /**
   *
   *
   * <pre>
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should
   * not be specified in the request (and will be ignored). Task count will be
   * the length of task_environments.
   *
   * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
   * addition to any environment variables set in task_environments, specifying
   * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
   * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
   */
  @java.lang.Override
  public int getTaskEnvironmentsCount() {
    return taskEnvironments_.size();
  }

  /**
   *
   *
   * <pre>
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should
   * not be specified in the request (and will be ignored). Task count will be
   * the length of task_environments.
   *
   * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
   * addition to any environment variables set in task_environments, specifying
   * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
   * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Environment getTaskEnvironments(int index) {
    return taskEnvironments_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An array of environment variable mappings, which are passed to Tasks with
   * matching indices. If task_environments is used then task_count should
   * not be specified in the request (and will be ignored). Task count will be
   * the length of task_environments.
   *
   * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
   * addition to any environment variables set in task_environments, specifying
   * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
   * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.EnvironmentOrBuilder getTaskEnvironmentsOrBuilder(int index) {
    return taskEnvironments_.get(index);
  }

  public static final int TASK_COUNT_PER_NODE_FIELD_NUMBER = 10;
  private long taskCountPerNode_ = 0L;

  /**
   *
   *
   * <pre>
   * Max number of tasks that can be run on a VM at the same time.
   * If not specified, the system will decide a value based on available
   * compute resources on a VM and task requirements.
   * </pre>
   *
   * <code>int64 task_count_per_node = 10;</code>
   *
   * @return The taskCountPerNode.
   */
  @java.lang.Override
  public long getTaskCountPerNode() {
    return taskCountPerNode_;
  }

  public static final int REQUIRE_HOSTS_FILE_FIELD_NUMBER = 11;
  private boolean requireHostsFile_ = false;

  /**
   *
   *
   * <pre>
   * When true, Batch will populate a file with a list of all VMs assigned to
   * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
   * of that file. Defaults to false. The host file supports up to 1000 VMs.
   * </pre>
   *
   * <code>bool require_hosts_file = 11;</code>
   *
   * @return The requireHostsFile.
   */
  @java.lang.Override
  public boolean getRequireHostsFile() {
    return requireHostsFile_;
  }

  public static final int PERMISSIVE_SSH_FIELD_NUMBER = 12;
  private boolean permissiveSsh_ = false;

  /**
   *
   *
   * <pre>
   * When true, Batch will configure SSH to allow passwordless login between
   * VMs running the Batch tasks in the same TaskGroup.
   * </pre>
   *
   * <code>bool permissive_ssh = 12;</code>
   *
   * @return The permissiveSsh.
   */
  @java.lang.Override
  public boolean getPermissiveSsh() {
    return permissiveSsh_;
  }

  public static final int RUN_AS_NON_ROOT_FIELD_NUMBER = 14;
  private boolean runAsNonRoot_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If not set or set to false, Batch uses the root user to execute
   * runnables. If set to true, Batch runs the runnables using a non-root user.
   * Currently, the non-root user Batch used is generated by OS Login. For more
   * information, see [About OS
   * Login](https://cloud.google.com/compute/docs/oslogin).
   * </pre>
   *
   * <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The runAsNonRoot.
   */
  @java.lang.Override
  public boolean getRunAsNonRoot() {
    return runAsNonRoot_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTaskSpec());
    }
    if (taskCount_ != 0L) {
      output.writeInt64(4, taskCount_);
    }
    if (parallelism_ != 0L) {
      output.writeInt64(5, parallelism_);
    }
    if (schedulingPolicy_
        != com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.SCHEDULING_POLICY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, schedulingPolicy_);
    }
    for (int i = 0; i < taskEnvironments_.size(); i++) {
      output.writeMessage(9, taskEnvironments_.get(i));
    }
    if (taskCountPerNode_ != 0L) {
      output.writeInt64(10, taskCountPerNode_);
    }
    if (requireHostsFile_ != false) {
      output.writeBool(11, requireHostsFile_);
    }
    if (permissiveSsh_ != false) {
      output.writeBool(12, permissiveSsh_);
    }
    if (runAsNonRoot_ != false) {
      output.writeBool(14, runAsNonRoot_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTaskSpec());
    }
    if (taskCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, taskCount_);
    }
    if (parallelism_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, parallelism_);
    }
    if (schedulingPolicy_
        != com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.SCHEDULING_POLICY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, schedulingPolicy_);
    }
    for (int i = 0; i < taskEnvironments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, taskEnvironments_.get(i));
    }
    if (taskCountPerNode_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, taskCountPerNode_);
    }
    if (requireHostsFile_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, requireHostsFile_);
    }
    if (permissiveSsh_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, permissiveSsh_);
    }
    if (runAsNonRoot_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, runAsNonRoot_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.TaskGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.TaskGroup other = (com.google.cloud.batch.v1.TaskGroup) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasTaskSpec() != other.hasTaskSpec()) return false;
    if (hasTaskSpec()) {
      if (!getTaskSpec().equals(other.getTaskSpec())) return false;
    }
    if (getTaskCount() != other.getTaskCount()) return false;
    if (getParallelism() != other.getParallelism()) return false;
    if (schedulingPolicy_ != other.schedulingPolicy_) return false;
    if (!getTaskEnvironmentsList().equals(other.getTaskEnvironmentsList())) return false;
    if (getTaskCountPerNode() != other.getTaskCountPerNode()) return false;
    if (getRequireHostsFile() != other.getRequireHostsFile()) return false;
    if (getPermissiveSsh() != other.getPermissiveSsh()) return false;
    if (getRunAsNonRoot() != other.getRunAsNonRoot()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasTaskSpec()) {
      hash = (37 * hash) + TASK_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getTaskSpec().hashCode();
    }
    hash = (37 * hash) + TASK_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTaskCount());
    hash = (37 * hash) + PARALLELISM_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getParallelism());
    hash = (37 * hash) + SCHEDULING_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + schedulingPolicy_;
    if (getTaskEnvironmentsCount() > 0) {
      hash = (37 * hash) + TASK_ENVIRONMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getTaskEnvironmentsList().hashCode();
    }
    hash = (37 * hash) + TASK_COUNT_PER_NODE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTaskCountPerNode());
    hash = (37 * hash) + REQUIRE_HOSTS_FILE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequireHostsFile());
    hash = (37 * hash) + PERMISSIVE_SSH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPermissiveSsh());
    hash = (37 * hash) + RUN_AS_NON_ROOT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunAsNonRoot());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.TaskGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.TaskGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A TaskGroup defines one or more Tasks that all share the same TaskSpec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.TaskGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.TaskGroup)
      com.google.cloud.batch.v1.TaskGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_TaskGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_TaskGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.TaskGroup.class,
              com.google.cloud.batch.v1.TaskGroup.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.TaskGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTaskSpecFieldBuilder();
        getTaskEnvironmentsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      taskSpec_ = null;
      if (taskSpecBuilder_ != null) {
        taskSpecBuilder_.dispose();
        taskSpecBuilder_ = null;
      }
      taskCount_ = 0L;
      parallelism_ = 0L;
      schedulingPolicy_ = 0;
      if (taskEnvironmentsBuilder_ == null) {
        taskEnvironments_ = java.util.Collections.emptyList();
      } else {
        taskEnvironments_ = null;
        taskEnvironmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      taskCountPerNode_ = 0L;
      requireHostsFile_ = false;
      permissiveSsh_ = false;
      runAsNonRoot_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_TaskGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskGroup getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.TaskGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskGroup build() {
      com.google.cloud.batch.v1.TaskGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.TaskGroup buildPartial() {
      com.google.cloud.batch.v1.TaskGroup result = new com.google.cloud.batch.v1.TaskGroup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.batch.v1.TaskGroup result) {
      if (taskEnvironmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          taskEnvironments_ = java.util.Collections.unmodifiableList(taskEnvironments_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.taskEnvironments_ = taskEnvironments_;
      } else {
        result.taskEnvironments_ = taskEnvironmentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.batch.v1.TaskGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.taskSpec_ = taskSpecBuilder_ == null ? taskSpec_ : taskSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.taskCount_ = taskCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parallelism_ = parallelism_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.schedulingPolicy_ = schedulingPolicy_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.taskCountPerNode_ = taskCountPerNode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.requireHostsFile_ = requireHostsFile_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.permissiveSsh_ = permissiveSsh_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.runAsNonRoot_ = runAsNonRoot_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.TaskGroup) {
        return mergeFrom((com.google.cloud.batch.v1.TaskGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.TaskGroup other) {
      if (other == com.google.cloud.batch.v1.TaskGroup.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTaskSpec()) {
        mergeTaskSpec(other.getTaskSpec());
      }
      if (other.getTaskCount() != 0L) {
        setTaskCount(other.getTaskCount());
      }
      if (other.getParallelism() != 0L) {
        setParallelism(other.getParallelism());
      }
      if (other.schedulingPolicy_ != 0) {
        setSchedulingPolicyValue(other.getSchedulingPolicyValue());
      }
      if (taskEnvironmentsBuilder_ == null) {
        if (!other.taskEnvironments_.isEmpty()) {
          if (taskEnvironments_.isEmpty()) {
            taskEnvironments_ = other.taskEnvironments_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTaskEnvironmentsIsMutable();
            taskEnvironments_.addAll(other.taskEnvironments_);
          }
          onChanged();
        }
      } else {
        if (!other.taskEnvironments_.isEmpty()) {
          if (taskEnvironmentsBuilder_.isEmpty()) {
            taskEnvironmentsBuilder_.dispose();
            taskEnvironmentsBuilder_ = null;
            taskEnvironments_ = other.taskEnvironments_;
            bitField0_ = (bitField0_ & ~0x00000020);
            taskEnvironmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTaskEnvironmentsFieldBuilder()
                    : null;
          } else {
            taskEnvironmentsBuilder_.addAllMessages(other.taskEnvironments_);
          }
        }
      }
      if (other.getTaskCountPerNode() != 0L) {
        setTaskCountPerNode(other.getTaskCountPerNode());
      }
      if (other.getRequireHostsFile() != false) {
        setRequireHostsFile(other.getRequireHostsFile());
      }
      if (other.getPermissiveSsh() != false) {
        setPermissiveSsh(other.getPermissiveSsh());
      }
      if (other.getRunAsNonRoot() != false) {
        setRunAsNonRoot(other.getRunAsNonRoot());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getTaskSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 32:
              {
                taskCount_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                parallelism_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                schedulingPolicy_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 74:
              {
                com.google.cloud.batch.v1.Environment m =
                    input.readMessage(
                        com.google.cloud.batch.v1.Environment.parser(), extensionRegistry);
                if (taskEnvironmentsBuilder_ == null) {
                  ensureTaskEnvironmentsIsMutable();
                  taskEnvironments_.add(m);
                } else {
                  taskEnvironmentsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                taskCountPerNode_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 88:
              {
                requireHostsFile_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 88
            case 96:
              {
                permissiveSsh_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 96
            case 112:
              {
                runAsNonRoot_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 112
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1.TaskSpec taskSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.TaskSpec,
            com.google.cloud.batch.v1.TaskSpec.Builder,
            com.google.cloud.batch.v1.TaskSpecOrBuilder>
        taskSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the taskSpec field is set.
     */
    public boolean hasTaskSpec() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The taskSpec.
     */
    public com.google.cloud.batch.v1.TaskSpec getTaskSpec() {
      if (taskSpecBuilder_ == null) {
        return taskSpec_ == null
            ? com.google.cloud.batch.v1.TaskSpec.getDefaultInstance()
            : taskSpec_;
      } else {
        return taskSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTaskSpec(com.google.cloud.batch.v1.TaskSpec value) {
      if (taskSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskSpec_ = value;
      } else {
        taskSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTaskSpec(com.google.cloud.batch.v1.TaskSpec.Builder builderForValue) {
      if (taskSpecBuilder_ == null) {
        taskSpec_ = builderForValue.build();
      } else {
        taskSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTaskSpec(com.google.cloud.batch.v1.TaskSpec value) {
      if (taskSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && taskSpec_ != null
            && taskSpec_ != com.google.cloud.batch.v1.TaskSpec.getDefaultInstance()) {
          getTaskSpecBuilder().mergeFrom(value);
        } else {
          taskSpec_ = value;
        }
      } else {
        taskSpecBuilder_.mergeFrom(value);
      }
      if (taskSpec_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTaskSpec() {
      bitField0_ = (bitField0_ & ~0x00000002);
      taskSpec_ = null;
      if (taskSpecBuilder_ != null) {
        taskSpecBuilder_.dispose();
        taskSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskSpec.Builder getTaskSpecBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTaskSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskSpecOrBuilder getTaskSpecOrBuilder() {
      if (taskSpecBuilder_ != null) {
        return taskSpecBuilder_.getMessageOrBuilder();
      } else {
        return taskSpec_ == null
            ? com.google.cloud.batch.v1.TaskSpec.getDefaultInstance()
            : taskSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Tasks in the group share the same task spec.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.TaskSpec,
            com.google.cloud.batch.v1.TaskSpec.Builder,
            com.google.cloud.batch.v1.TaskSpecOrBuilder>
        getTaskSpecFieldBuilder() {
      if (taskSpecBuilder_ == null) {
        taskSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.TaskSpec,
                com.google.cloud.batch.v1.TaskSpec.Builder,
                com.google.cloud.batch.v1.TaskSpecOrBuilder>(
                getTaskSpec(), getParentForChildren(), isClean());
        taskSpec_ = null;
      }
      return taskSpecBuilder_;
    }

    private long taskCount_;

    /**
     *
     *
     * <pre>
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     * </pre>
     *
     * <code>int64 task_count = 4;</code>
     *
     * @return The taskCount.
     */
    @java.lang.Override
    public long getTaskCount() {
      return taskCount_;
    }

    /**
     *
     *
     * <pre>
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     * </pre>
     *
     * <code>int64 task_count = 4;</code>
     *
     * @param value The taskCount to set.
     * @return This builder for chaining.
     */
    public Builder setTaskCount(long value) {

      taskCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     * </pre>
     *
     * <code>int64 task_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      taskCount_ = 0L;
      onChanged();
      return this;
    }

    private long parallelism_;

    /**
     *
     *
     * <pre>
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     * </pre>
     *
     * <code>int64 parallelism = 5;</code>
     *
     * @return The parallelism.
     */
    @java.lang.Override
    public long getParallelism() {
      return parallelism_;
    }

    /**
     *
     *
     * <pre>
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     * </pre>
     *
     * <code>int64 parallelism = 5;</code>
     *
     * @param value The parallelism to set.
     * @return This builder for chaining.
     */
    public Builder setParallelism(long value) {

      parallelism_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     * </pre>
     *
     * <code>int64 parallelism = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParallelism() {
      bitField0_ = (bitField0_ & ~0x00000008);
      parallelism_ = 0L;
      onChanged();
      return this;
    }

    private int schedulingPolicy_ = 0;

    /**
     *
     *
     * <pre>
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     *
     * @return The enum numeric value on the wire for schedulingPolicy.
     */
    @java.lang.Override
    public int getSchedulingPolicyValue() {
      return schedulingPolicy_;
    }

    /**
     *
     *
     * <pre>
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     *
     * @param value The enum numeric value on the wire for schedulingPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingPolicyValue(int value) {
      schedulingPolicy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     *
     * @return The schedulingPolicy.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy getSchedulingPolicy() {
      com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy result =
          com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.forNumber(schedulingPolicy_);
      return result == null
          ? com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     *
     * @param value The schedulingPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSchedulingPolicy(com.google.cloud.batch.v1.TaskGroup.SchedulingPolicy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      schedulingPolicy_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedulingPolicy() {
      bitField0_ = (bitField0_ & ~0x00000010);
      schedulingPolicy_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1.Environment> taskEnvironments_ =
        java.util.Collections.emptyList();

    private void ensureTaskEnvironmentsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        taskEnvironments_ =
            new java.util.ArrayList<com.google.cloud.batch.v1.Environment>(taskEnvironments_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Environment,
            com.google.cloud.batch.v1.Environment.Builder,
            com.google.cloud.batch.v1.EnvironmentOrBuilder>
        taskEnvironmentsBuilder_;

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Environment> getTaskEnvironmentsList() {
      if (taskEnvironmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(taskEnvironments_);
      } else {
        return taskEnvironmentsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public int getTaskEnvironmentsCount() {
      if (taskEnvironmentsBuilder_ == null) {
        return taskEnvironments_.size();
      } else {
        return taskEnvironmentsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public com.google.cloud.batch.v1.Environment getTaskEnvironments(int index) {
      if (taskEnvironmentsBuilder_ == null) {
        return taskEnvironments_.get(index);
      } else {
        return taskEnvironmentsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder setTaskEnvironments(int index, com.google.cloud.batch.v1.Environment value) {
      if (taskEnvironmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.set(index, value);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder setTaskEnvironments(
        int index, com.google.cloud.batch.v1.Environment.Builder builderForValue) {
      if (taskEnvironmentsBuilder_ == null) {
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.set(index, builderForValue.build());
        onChanged();
      } else {
        taskEnvironmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder addTaskEnvironments(com.google.cloud.batch.v1.Environment value) {
      if (taskEnvironmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.add(value);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder addTaskEnvironments(int index, com.google.cloud.batch.v1.Environment value) {
      if (taskEnvironmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.add(index, value);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder addTaskEnvironments(
        com.google.cloud.batch.v1.Environment.Builder builderForValue) {
      if (taskEnvironmentsBuilder_ == null) {
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.add(builderForValue.build());
        onChanged();
      } else {
        taskEnvironmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder addTaskEnvironments(
        int index, com.google.cloud.batch.v1.Environment.Builder builderForValue) {
      if (taskEnvironmentsBuilder_ == null) {
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.add(index, builderForValue.build());
        onChanged();
      } else {
        taskEnvironmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder addAllTaskEnvironments(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.Environment> values) {
      if (taskEnvironmentsBuilder_ == null) {
        ensureTaskEnvironmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, taskEnvironments_);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder clearTaskEnvironments() {
      if (taskEnvironmentsBuilder_ == null) {
        taskEnvironments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public Builder removeTaskEnvironments(int index) {
      if (taskEnvironmentsBuilder_ == null) {
        ensureTaskEnvironmentsIsMutable();
        taskEnvironments_.remove(index);
        onChanged();
      } else {
        taskEnvironmentsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public com.google.cloud.batch.v1.Environment.Builder getTaskEnvironmentsBuilder(int index) {
      return getTaskEnvironmentsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public com.google.cloud.batch.v1.EnvironmentOrBuilder getTaskEnvironmentsOrBuilder(int index) {
      if (taskEnvironmentsBuilder_ == null) {
        return taskEnvironments_.get(index);
      } else {
        return taskEnvironmentsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.EnvironmentOrBuilder>
        getTaskEnvironmentsOrBuilderList() {
      if (taskEnvironmentsBuilder_ != null) {
        return taskEnvironmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(taskEnvironments_);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public com.google.cloud.batch.v1.Environment.Builder addTaskEnvironmentsBuilder() {
      return getTaskEnvironmentsFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.Environment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public com.google.cloud.batch.v1.Environment.Builder addTaskEnvironmentsBuilder(int index) {
      return getTaskEnvironmentsFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.Environment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     *
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.Environment.Builder>
        getTaskEnvironmentsBuilderList() {
      return getTaskEnvironmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.Environment,
            com.google.cloud.batch.v1.Environment.Builder,
            com.google.cloud.batch.v1.EnvironmentOrBuilder>
        getTaskEnvironmentsFieldBuilder() {
      if (taskEnvironmentsBuilder_ == null) {
        taskEnvironmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.Environment,
                com.google.cloud.batch.v1.Environment.Builder,
                com.google.cloud.batch.v1.EnvironmentOrBuilder>(
                taskEnvironments_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        taskEnvironments_ = null;
      }
      return taskEnvironmentsBuilder_;
    }

    private long taskCountPerNode_;

    /**
     *
     *
     * <pre>
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     * </pre>
     *
     * <code>int64 task_count_per_node = 10;</code>
     *
     * @return The taskCountPerNode.
     */
    @java.lang.Override
    public long getTaskCountPerNode() {
      return taskCountPerNode_;
    }

    /**
     *
     *
     * <pre>
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     * </pre>
     *
     * <code>int64 task_count_per_node = 10;</code>
     *
     * @param value The taskCountPerNode to set.
     * @return This builder for chaining.
     */
    public Builder setTaskCountPerNode(long value) {

      taskCountPerNode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     * </pre>
     *
     * <code>int64 task_count_per_node = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskCountPerNode() {
      bitField0_ = (bitField0_ & ~0x00000040);
      taskCountPerNode_ = 0L;
      onChanged();
      return this;
    }

    private boolean requireHostsFile_;

    /**
     *
     *
     * <pre>
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     * </pre>
     *
     * <code>bool require_hosts_file = 11;</code>
     *
     * @return The requireHostsFile.
     */
    @java.lang.Override
    public boolean getRequireHostsFile() {
      return requireHostsFile_;
    }

    /**
     *
     *
     * <pre>
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     * </pre>
     *
     * <code>bool require_hosts_file = 11;</code>
     *
     * @param value The requireHostsFile to set.
     * @return This builder for chaining.
     */
    public Builder setRequireHostsFile(boolean value) {

      requireHostsFile_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     * </pre>
     *
     * <code>bool require_hosts_file = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequireHostsFile() {
      bitField0_ = (bitField0_ & ~0x00000080);
      requireHostsFile_ = false;
      onChanged();
      return this;
    }

    private boolean permissiveSsh_;

    /**
     *
     *
     * <pre>
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     * </pre>
     *
     * <code>bool permissive_ssh = 12;</code>
     *
     * @return The permissiveSsh.
     */
    @java.lang.Override
    public boolean getPermissiveSsh() {
      return permissiveSsh_;
    }

    /**
     *
     *
     * <pre>
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     * </pre>
     *
     * <code>bool permissive_ssh = 12;</code>
     *
     * @param value The permissiveSsh to set.
     * @return This builder for chaining.
     */
    public Builder setPermissiveSsh(boolean value) {

      permissiveSsh_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     * </pre>
     *
     * <code>bool permissive_ssh = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPermissiveSsh() {
      bitField0_ = (bitField0_ & ~0x00000100);
      permissiveSsh_ = false;
      onChanged();
      return this;
    }

    private boolean runAsNonRoot_;

    /**
     *
     *
     * <pre>
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     * </pre>
     *
     * <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The runAsNonRoot.
     */
    @java.lang.Override
    public boolean getRunAsNonRoot() {
      return runAsNonRoot_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     * </pre>
     *
     * <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The runAsNonRoot to set.
     * @return This builder for chaining.
     */
    public Builder setRunAsNonRoot(boolean value) {

      runAsNonRoot_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     * </pre>
     *
     * <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunAsNonRoot() {
      bitField0_ = (bitField0_ & ~0x00000200);
      runAsNonRoot_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.TaskGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.TaskGroup)
  private static final com.google.cloud.batch.v1.TaskGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.TaskGroup();
  }

  public static com.google.cloud.batch.v1.TaskGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TaskGroup> PARSER =
      new com.google.protobuf.AbstractParser<TaskGroup>() {
        @java.lang.Override
        public TaskGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TaskGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TaskGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.TaskGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
