/*
 * Decompiled with CFR 0.152.
 */
package tray.balloon;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.SwingUtilities;

public class IconCanvas
extends Canvas {
    volatile Image image;
    IconObserver observer;
    int width;
    int height;
    int curW;
    int curH;

    IconCanvas(int width, int height) {
        this.width = this.curW = width;
        this.height = this.curH = height;
    }

    public void updateImage(Image image) {
        this.image = image;
        if (this.observer == null) {
            this.observer = new IconObserver();
        }
        this.repaintImage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repaintImage(boolean doClear) {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                if (this.isVisible()) {
                    if (doClear) {
                        this.update(g);
                    } else {
                        this.paint(g);
                    }
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BufferedImage bufImage;
        Graphics2D gr;
        if (g != null && this.curW > 0 && this.curH > 0 && (gr = (bufImage = new BufferedImage(this.curW, this.curH, 2)).createGraphics()) != null) {
            try {
                gr.setColor(this.getBackground());
                gr.fillRect(0, 0, this.curW, this.curH);
                gr.drawImage(this.image, 0, 0, this.curW, this.curH, this.observer);
                gr.dispose();
                g.drawImage(bufImage, 0, 0, this.curW, this.curH, null);
            }
            finally {
                gr.dispose();
            }
        }
    }

    class IconObserver
    implements ImageObserver {
        IconObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            if (image != IconCanvas.this.image || !IconCanvas.this.isVisible()) {
                return false;
            }
            if ((flags & 0x33) != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IconCanvas.this.repaintImage(false);
                    }
                });
            }
            return (flags & 0x20) == 0;
        }
    }
}

