/*
 * Decompiled with CFR 0.152.
 */
package tray.balloon;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.BreakIterator;
import javax.swing.SwingUtilities;
import tray.balloon.IconCanvas;
import tray.balloon.InfoWindow;

public class Balloon
extends InfoWindow {
    static final int BALLOON_SHOW_TIME = 10000;
    static final int BALLOON_TEXT_MAX_LENGTH = 256;
    static final int BALLOON_WORD_LINE_MAX_LENGTH = 16;
    static final int BALLOON_WORD_LINE_MAX_COUNT = 4;
    static final int BALLOON_ICON_WIDTH = 32;
    static final int BALLOON_ICON_HEIGHT = 32;
    static final int BALLOON_TRAY_ICON_INDENT = 0;
    static final Color BALLOON_CAPTION_BACKGROUND_COLOR = new Color(200, 200, 255);
    static final Font BALLOON_CAPTION_FONT = new Font("Dialog", 1, 12);
    Panel mainPanel = new Panel();
    Panel captionPanel = new Panel();
    Label captionLabel = new Label("");
    Button closeButton = new Button("X");
    Panel textPanel = new Panel();
    IconCanvas iconCanvas = new IconCanvas(32, 32);
    Label[] lineLabels = new Label[4];
    ActionPerformer ap = new ActionPerformer();
    Image iconImage;
    Image errorImage;
    Image warnImage;
    Image infoImage;
    boolean gtkImagesLoaded;

    public Balloon() {
        super(null, new Color(90, 80, 190));
        this.setCloser(new Runnable(){

            @Override
            public void run() {
                if (Balloon.this.textPanel != null) {
                    Balloon.this.textPanel.removeAll();
                    Balloon.this.textPanel.setSize(0, 0);
                    Balloon.this.iconCanvas.setSize(0, 0);
                }
            }
        }, 10000);
        this.add(this.mainPanel);
        this.captionLabel.setFont(BALLOON_CAPTION_FONT);
        this.captionLabel.addMouseListener(this.ap);
        this.captionPanel.setLayout(new BorderLayout());
        this.captionPanel.add((Component)this.captionLabel, "West");
        this.captionPanel.add((Component)this.closeButton, "East");
        this.captionPanel.setBackground(BALLOON_CAPTION_BACKGROUND_COLOR);
        this.captionPanel.addMouseListener(this.ap);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Balloon.this.hide();
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.add((Component)this.captionPanel, "North");
        this.mainPanel.add((Component)this.textPanel, "Center");
        this.mainPanel.add((Component)this.iconCanvas, "West");
        for (int i = 0; i < 4; ++i) {
            this.lineLabels[i] = new Label();
            this.lineLabels[i].addMouseListener(this.ap);
            this.lineLabels[i].setBackground(Color.white);
        }
    }

    public void display(String caption, String text, TrayIcon.MessageType messageType) {
        if (!this.gtkImagesLoaded) {
            this.loadGtkImages();
        }
        this.captionLabel.setText(caption);
        this.renderText(text);
        this.setMessageIconBasedOnMessageType(messageType);
        this.renderBalloon();
    }

    private void setMessageIconBasedOnMessageType(TrayIcon.MessageType messageType) {
        switch (messageType) {
            case ERROR: {
                this.iconImage = this.errorImage;
                break;
            }
            case INFO: {
                this.iconImage = this.infoImage;
                break;
            }
            case WARNING: {
                this.iconImage = this.warnImage;
                break;
            }
            default: {
                this.iconImage = null;
            }
        }
        if (this.iconImage != null) {
            Dimension tpSize = this.textPanel.getSize();
            this.iconCanvas.setSize(32, 32 > tpSize.height ? 32 : tpSize.height);
        }
    }

    private void renderBalloon() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle bounds = Balloon.this.getBounds();
                Point parLoc = new Point(bounds.x, bounds.y);
                Dimension parSize = new Dimension(bounds.height, bounds.width);
                Balloon.this.show(new Point(parLoc.x + parSize.width / 2, parLoc.y + parSize.height / 2), 0);
                if (Balloon.this.iconImage != null) {
                    Balloon.this.iconCanvas.updateImage(Balloon.this.iconImage);
                }
            }
        });
    }

    private void renderText(String text) {
        BreakIterator iter = BreakIterator.getWordInstance();
        if (text != null) {
            int end;
            iter.setText(text);
            int start = iter.first();
            int nLines = 0;
            do {
                if ((end = iter.next()) == -1 || text.substring(start, end).length() >= 50) {
                    this.lineLabels[nLines].setText(text.substring(start, end == -1 ? iter.last() : end));
                    this.textPanel.add(this.lineLabels[nLines++]);
                    start = end;
                }
                if (nLines != 4) continue;
                if (end == -1) break;
                this.lineLabels[nLines - 1].setText(new String(this.lineLabels[nLines - 1].getText() + " ..."));
                break;
            } while (end != -1);
            this.textPanel.setLayout(new GridLayout(nLines, 1));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    void loadGtkImages() {
        if (!this.gtkImagesLoaded) {
            this.errorImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-error.6.rtl");
            this.warnImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-warning.6.rtl");
            this.infoImage = (Image)Toolkit.getDefaultToolkit().getDesktopProperty("gtk.icon.gtk-dialog-info.6.rtl");
            this.gtkImagesLoaded = true;
        }
    }

    class Message {
        String caption;
        String text;
        TrayIcon.MessageType messageType;

        Message(String caption, String text, TrayIcon.MessageType messageType2) {
            this.caption = caption;
            this.text = text;
            this.messageType = messageType2;
        }
    }

    class ActionPerformer
    extends MouseAdapter {
        ActionPerformer() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Balloon.this.hide();
        }
    }
}

