/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.InterpolableNamePart;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableNamePart;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.strings.StringInterpolator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IteratedScope;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.ArgumentsBuilder;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.compiler.stages.MixinsReferenceMatcher;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.QuotesKeepingInStringCssPrinter;
import java.util.ArrayList;
import java.util.List;

public class ReferencesSolver {
    public static final String ALL_ARGUMENTS = "@arguments";
    private ASTManipulator manipulator = new ASTManipulator();
    private final ProblemsHandler problemsHandler;
    private StringInterpolator stringInterpolator = new StringInterpolator();

    public ReferencesSolver(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void solveReferences(ASTCssNode node, Scope scope) {
        this.doSolveReferences(node, new IteratedScope(scope));
    }

    private void doSolveReferences(ASTCssNode node, Scope scope) {
        this.doSolveReferences(node, new IteratedScope(scope));
    }

    private void doSolveReferences(ASTCssNode node, IteratedScope scope) {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(scope.getScope(), this.problemsHandler);
        switch (node.getType()) {
            case VARIABLE: {
                ASTCssNode replacement = expressionEvaluator.evaluate((Variable)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case INDIRECT_VARIABLE: {
                ASTCssNode replacement = expressionEvaluator.evaluate((IndirectVariable)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case STRING_EXPRESSION: {
                ASTCssNode replacement = expressionEvaluator.evaluate((CssString)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case ESCAPED_VALUE: {
                ASTCssNode replacement = expressionEvaluator.evaluate((EscapedValue)node);
                this.manipulator.replace(node, replacement);
                break;
            }
            case MIXIN_REFERENCE: {
                MixinReference mixinReference = (MixinReference)node;
                ASTCssNode replacement = this.resolveMixinReference(mixinReference, scope.getScope());
                AstLogic.validateCssBodyCompatibility(mixinReference, ((Body)replacement).getChilds(), this.problemsHandler);
                this.manipulator.replaceInBody(mixinReference, ((Body)replacement).getChilds());
                break;
            }
            case ESCAPED_SELECTOR: {
                ASTCssNode replacement = this.interpolateEscapedSelector((EscapedSelector)node, expressionEvaluator);
                this.manipulator.replace(node, replacement);
                break;
            }
            case FIXED_NAME_PART: {
                InterpolableNamePart part = (FixedNamePart)node;
                ASTCssNode replacement = this.interpolateFixedNamePart((FixedNamePart)part, expressionEvaluator);
                part.getParent().replaceMember(part, (InterpolableNamePart)replacement);
                break;
            }
            case VARIABLE_NAME_PART: {
                InterpolableNamePart part = (VariableNamePart)node;
                Expression value = expressionEvaluator.evaluate(((VariableNamePart)part).getVariable());
                FixedNamePart fixedNamePart = this.toFixedName(value, node.getUnderlyingStructure());
                part.getParent().replaceMember(part, this.interpolateFixedNamePart(fixedNamePart, expressionEvaluator));
                break;
            }
        }
        if (node.getType() != ASTCssNodeType.VARIABLE_NAME_PART) {
            ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
            for (ASTCssNode aSTCssNode : childs) {
                if (AstLogic.hasOwnScope(aSTCssNode)) {
                    this.doSolveReferences(aSTCssNode, new IteratedScope(scope.getNextChild()));
                    continue;
                }
                this.doSolveReferences(aSTCssNode, scope);
            }
        }
    }

    private FixedNamePart toFixedName(Expression value, HiddenTokenAwareTree parent) {
        QuotesKeepingInStringCssPrinter printer = new QuotesKeepingInStringCssPrinter();
        printer.append(value);
        FixedNamePart fixedName = new FixedNamePart(parent, printer.toString());
        return fixedName;
    }

    private EscapedSelector interpolateEscapedSelector(EscapedSelector input, ExpressionEvaluator expressionEvaluator) {
        String value = this.stringInterpolator.replaceIn(input.getValue(), expressionEvaluator, input.getUnderlyingStructure());
        return new EscapedSelector(input.getUnderlyingStructure(), value, input.getQuoteType());
    }

    private FixedNamePart interpolateFixedNamePart(FixedNamePart input, ExpressionEvaluator expressionEvaluator) {
        String value = this.stringInterpolator.replaceIn(input.getName(), expressionEvaluator, input.getUnderlyingStructure());
        return new FixedNamePart(input.getUnderlyingStructure(), value);
    }

    private RuleSetsBody resolveMixinReference(MixinReference reference, Scope scope) {
        List<FullMixinDefinition> sameNameMixins = scope.getNearestMixins(reference, this.problemsHandler);
        return this.resolveReferencedMixins(reference, scope, sameNameMixins);
    }

    private RuleSetsBody resolveReferencedMixins(MixinReference reference, Scope referenceScope, List<FullMixinDefinition> sameNameMixins) {
        List<FullMixinDefinition> mixins;
        if (sameNameMixins.isEmpty()) {
            this.problemsHandler.undefinedMixin(reference);
        }
        if ((mixins = new MixinsReferenceMatcher(referenceScope, this.problemsHandler).filter(reference, sameNameMixins)).isEmpty()) {
            this.problemsHandler.unmatchedMixin(reference);
        }
        RuleSetsBody result = new RuleSetsBody(reference.getUnderlyingStructure());
        for (FullMixinDefinition fullMixin : mixins) {
            ReusableStructure mixin;
            Scope combinedScope = this.calculateMixinsOwnVariables(reference, referenceScope, fullMixin);
            ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(combinedScope, this.problemsHandler);
            if (!expressionEvaluator.evaluate((mixin = fullMixin.getMixin()).getGuards())) continue;
            RuleSetsBody body = mixin.getBody().clone();
            this.doSolveReferences((ASTCssNode)body, combinedScope);
            result.addMembers(body.getChilds());
        }
        this.resolveImportance(reference, result);
        this.shiftComments(reference, result);
        return result;
    }

    private void shiftComments(MixinReference reference, RuleSetsBody result) {
        List childs = result.getChilds();
        if (!childs.isEmpty()) {
            ((ASTCssNode)childs.get(0)).addOpeningComments(reference.getOpeningComments());
            ((ASTCssNode)childs.get(childs.size() - 1)).addTrailingComments(reference.getTrailingComments());
        }
    }

    private void resolveImportance(MixinReference reference, RuleSetsBody result) {
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
    }

    private void declarationsAreImportant(RuleSetsBody result) {
        for (ASTCssNode kid : result.getChilds()) {
            if (!(kid instanceof Declaration)) continue;
            Declaration declaration = (Declaration)kid;
            declaration.setImportant(true);
        }
    }

    private Scope calculateMixinsOwnVariables(MixinReference reference, Scope referenceScope, FullMixinDefinition mixin) {
        Scope joinScopes = ReferencesSolver.joinScopes(mixin.getScope(), this.buildMixinsArgumentsScope(reference, referenceScope, mixin), referenceScope);
        return joinScopes;
    }

    public static Scope joinScopes(Scope mixinsScope, Scope arguments, Scope callerScope) {
        Scope result = mixinsScope.copyWithChildChain(arguments);
        Scope mixinsScopeParent = mixinsScope.getParent();
        if (mixinsScopeParent != null) {
            arguments.setParent(mixinsScopeParent.copyWithParentsChain());
        }
        Scope rootOfTheMixinsScope = result.getRootScope();
        rootOfTheMixinsScope.setParent(callerScope.copyWithParentsChain());
        return result;
    }

    private Scope buildMixinsArgumentsScope(MixinReference reference, Scope referenceScope, FullMixinDefinition mixin) {
        ArgumentsBuilder builder = new ArgumentsBuilder(reference, mixin.getMixin(), new ExpressionEvaluator(referenceScope, this.problemsHandler), this.problemsHandler);
        return builder.build();
    }
}

