/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MixinReference
extends ASTCssNode {
    private List<ReusableStructureName> nameChain = new ArrayList<ReusableStructureName>();
    private ReusableStructureName finalName;
    private List<Expression> positionalParameters = new ArrayList<Expression>();
    private Map<String, Expression> namedParameters = new HashMap<String, Expression>();
    private boolean important = false;

    public MixinReference(HiddenTokenAwareTree token) {
        super(token);
    }

    public ReusableStructureName getFinalName() {
        return this.finalName;
    }

    public String getFinalNameAsString() {
        return this.getFinalName().asString();
    }

    public void setFinalName(ReusableStructureName name) {
        this.finalName = name;
    }

    public List<ReusableStructureName> getNameChain() {
        return this.nameChain;
    }

    public boolean hasInterpolatedNameChain() {
        for (ReusableStructureName name : this.nameChain) {
            if (!name.isInterpolated()) continue;
            return true;
        }
        return false;
    }

    public List<String> getNameChainAsStrings() {
        ArrayList<String> result = new ArrayList<String>();
        for (ReusableStructureName name : this.nameChain) {
            result.add(name.asString());
        }
        return result;
    }

    public void setNameChain(List<ReusableStructureName> nameChain) {
        this.nameChain = nameChain;
    }

    public List<Expression> getPositionalParameters() {
        return this.positionalParameters;
    }

    public int getNumberOfDeclaredParameters() {
        return this.positionalParameters.size() + this.namedParameters.size();
    }

    public boolean hasNamedParameter(Variable variable) {
        return this.namedParameters.containsKey(variable.getName());
    }

    public Expression getNamedParameter(Variable variable) {
        return this.namedParameters.get(variable.getName());
    }

    public void addName(ReusableStructureName text) {
        this.nameChain.add(text);
    }

    public void addNames(List<ReusableStructureName> nameChain) {
        this.nameChain.addAll(nameChain);
    }

    public boolean hasPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().size() > parameterNumber;
    }

    public Expression getPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().get(parameterNumber);
    }

    public void addPositionalParameter(Expression parameter) {
        this.positionalParameters.add(parameter);
    }

    public void addNamedParameter(VariableDeclaration parameter) {
        this.namedParameters.put(parameter.getVariable().getName(), parameter.getValue());
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public boolean hasInterpolatedFinalName() {
        return this.finalName.isInterpolated();
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.finalName);
        result.addAll(this.nameChain);
        result.addAll(this.positionalParameters);
        result.addAll(this.namedParameters.values());
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MIXIN_REFERENCE;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MixinReference[");
        for (ReusableStructureName str : this.nameChain) {
            builder.append(str.asString()).append(" > ");
        }
        builder.append(this.getFinalName()).append("]");
        return builder.toString();
    }

    @Override
    public MixinReference clone() {
        MixinReference result = (MixinReference)super.clone();
        result.nameChain = this.nameChain == null ? null : new ArrayList<ReusableStructureName>(this.nameChain);
        result.finalName = this.finalName == null ? null : this.finalName.clone();
        result.positionalParameters = ArraysUtils.deeplyClonedList(this.positionalParameters);
        result.configureParentToAllChilds();
        return result;
    }

    public List<Expression> getAllPositionalArgumentsFrom(int startIndx) {
        if (this.hasPositionalParameter(startIndx)) {
            return this.positionalParameters.subList(startIndx, this.positionalParameters.size());
        }
        return Collections.emptyList();
    }
}

