/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class MediaExpression
extends ASTCssNode {
    private MediaExpressionFeature feature;
    private Expression expression;

    public MediaExpression(HiddenTokenAwareTree underlyingStructure, MediaExpressionFeature feature, Expression expression) {
        super(underlyingStructure);
        this.feature = feature;
        this.expression = expression;
    }

    public MediaExpressionFeature getFeature() {
        return this.feature;
    }

    public void setFeature(MediaExpressionFeature feature) {
        this.feature = feature;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MEDIA_EXPRESSION;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.feature, this.expression);
    }

    @Override
    public MediaExpression clone() {
        MediaExpression result = (MediaExpression)super.clone();
        result.feature = this.feature == null ? null : this.feature.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

