/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.List;

public class ColorExpression
extends Expression {
    private String value;
    private int red;
    private int green;
    private int blue;

    public ColorExpression(HiddenTokenAwareTree token, String value) {
        super(token);
        this.setValue(value);
    }

    public ColorExpression(HiddenTokenAwareTree token, int red, int green, int blue) {
        super(token);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.value = this.encode(red, green, blue);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.red = this.decode(value, 0);
        this.green = this.decode(value, 1);
        this.blue = this.decode(value, 2);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    private int decode(String color, int i) {
        if (color.length() < 7) {
            String substring = color.substring(i + 1, i + 2);
            return Integer.parseInt(substring + substring, 16);
        }
        return Integer.parseInt(color.substring(i * 2 + 1, i * 2 + 3), 16);
    }

    private String encode(int red, int green, int blue) {
        return "#" + this.toHex(red) + this.toHex(green) + this.toHex(blue);
    }

    private String toHex(int color) {
        String prefix = "";
        if (color < 16) {
            prefix = "0";
        }
        return prefix + Integer.toHexString(color);
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.COLOR_EXPRESSION;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public ColorExpression clone() {
        return (ColorExpression)super.clone();
    }
}

