/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Iterator;

public class SelectorBuilder {
    private final HiddenTokenAwareTree token;
    private final ASTBuilderSwitch parent;

    public SelectorBuilder(HiddenTokenAwareTree token, ASTBuilderSwitch astBuilderSwitch) {
        this.token = token;
        this.parent = astBuilderSwitch;
    }

    public Selector buildSelector() {
        Iterator<HiddenTokenAwareTree> iterator = this.token.getChildren().iterator();
        Selector result = null;
        Selector rightest = null;
        while (iterator.hasNext()) {
            SelectorCombinator combinator = null;
            SelectorPart head = null;
            HiddenTokenAwareTree kid = iterator.next();
            if (kid.getType() == 11 || kid.getType() == 13) {
                head = (SelectorPart)this.parent.switchOn(kid);
            } else {
                combinator = ConversionUtils.createSelectorCombinator(kid);
                kid = iterator.next();
                head = (SelectorPart)this.parent.switchOn(kid);
                if (this.isDescendant(combinator) && kid.getType() == 11) {
                    combinator = null;
                }
            }
            Selector part = new Selector(this.token, combinator, head);
            if (result == null) {
                result = part;
                rightest = part;
                continue;
            }
            rightest.setRight(part);
            rightest = part;
        }
        return result;
    }

    private boolean isDescendant(SelectorCombinator combinator) {
        return combinator != null && combinator.getCombinator() == SelectorCombinator.Combinator.DESCENDANT;
    }
}

