/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.BodiesStorage;
import com.github.sommeri.less4j.core.compiler.stages.NestedMediaCollector;
import com.github.sommeri.less4j.core.compiler.stages.ParentChainIterator;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

public class MediaBubblerAndMerger {
    private ASTManipulator astManipulator = new ASTManipulator();
    private ProblemsHandler problemsHandler;

    public MediaBubblerAndMerger(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void bubbleAndMergeMedia(StyleSheet node) {
        this.bubbleUp(node);
        this.mergeTopLevelMedias(node);
    }

    private void mergeTopLevelMedias(StyleSheet node) {
        NestedMediaCollector nestedMediaCollector = new NestedMediaCollector(this.problemsHandler);
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode kid : childs) {
            switch (kid.getType()) {
                case MEDIA: {
                    List<Media> nestedMedia = nestedMediaCollector.collectMedia((Media)kid);
                    this.astManipulator.addIntoBody(nestedMedia, kid);
                    break;
                }
            }
        }
    }

    private void bubbleUp(ASTCssNode node) {
        switch (node.getType()) {
            case MEDIA: {
                this.bubbleUp((Media)node);
                break;
            }
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.bubbleUp(aSTCssNode);
        }
    }

    private void bubbleUp(Media media) {
        ParentChainIterator parentChainIterator = new ParentChainIterator(media);
        if (parentChainIterator.finished()) {
            return;
        }
        this.astManipulator.removeFromBody(media);
        BodiesStorage bodiesStorage = new BodiesStorage();
        Body oldBody = parentChainIterator.getParentAsBody();
        ASTCssNode currentNode = parentChainIterator.getCurrentNode();
        parentChainIterator.moveUpToNextBody();
        Body emptyClone = bodiesStorage.storeAndReplaceBySingleMemberClone(oldBody, null);
        this.astManipulator.moveMembersBetweenBodies(media.getBody(), emptyClone);
        while (!parentChainIterator.finished()) {
            oldBody = parentChainIterator.getParentAsBody();
            currentNode = parentChainIterator.getCurrentNode();
            parentChainIterator.moveUpToNextBody();
            bodiesStorage.storeAndReplaceBySingleMemberClone(oldBody, currentNode);
        }
        currentNode = parentChainIterator.getCurrentNode();
        ASTCssNode currentNodeClone = currentNode.clone();
        media.getBody().addMember(currentNodeClone);
        currentNodeClone.setParent(media.getBody());
        bodiesStorage.restore();
        this.astManipulator.addIntoBody(media, currentNode);
    }
}

