/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractFunction;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.InStringCssPrinter;
import java.util.List;

class E
extends AbstractFunction {
    E() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression parameter;
        if (parameters.size() > 1) {
            problemsHandler.wrongNumberOfArgumentsToFunction(call.getParameter(), call.getName(), 1);
        }
        if ((parameter = parameters.get(0)).getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameter);
        }
        if (parameter.getType() == ASTCssNodeType.ESCAPED_VALUE) {
            return this.evaluate((EscapedValue)parameter);
        }
        if (parameter.getType() == ASTCssNodeType.NUMBER) {
            return this.evaluate((NumberExpression)parameter);
        }
        problemsHandler.warnEFunctionArgument(parameter);
        return new FaultyExpression(call.getParameter());
    }

    private Expression evaluate(NumberExpression parameters) {
        InStringCssPrinter printer = new InStringCssPrinter();
        printer.append(parameters);
        return new CssString(parameters.getUnderlyingStructure(), printer.toString(), "");
    }

    private Expression evaluate(EscapedValue parameters) {
        return parameters;
    }

    private CssString evaluate(CssString parameters) {
        return new CssString(parameters.getUnderlyingStructure(), parameters.getValue(), "");
    }
}

