/*
 * Decompiled with CFR 0.152.
 */
package com.github.romankh3.image.comparison;

import com.github.romankh3.image.comparison.exception.ImageComparisonException;
import com.github.romankh3.image.comparison.exception.ImageNotFoundException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ImageComparisonUtil {
    static BufferedImage deepCopy(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage readImageFromResources(String path) throws ImageComparisonException {
        File imageFile = new File(path);
        if (imageFile.exists()) {
            try {
                return ImageIO.read(imageFile);
            }
            catch (IOException e) {
                throw new ImageComparisonException(String.format("Cannot read image from the file, path=%s", path), e);
            }
        }
        InputStream inputStream = ImageComparisonUtil.class.getClassLoader().getResourceAsStream(path);
        if (inputStream != null) {
            try {
                return ImageIO.read(inputStream);
            }
            catch (IOException e) {
                throw new ImageComparisonException(String.format("Cannot read image from the file, path=%s", path), e);
            }
        }
        throw new ImageNotFoundException(String.format("Image with path = %s not found", path));
    }

    public static void saveImage(File pathFile, BufferedImage image) throws ImageComparisonException {
        boolean dirExists;
        File dir = pathFile.getParentFile();
        boolean bl = dirExists = dir == null || dir.isDirectory() || dir.mkdirs();
        if (!dirExists) {
            throw new ImageComparisonException("Unable to create directory " + dir);
        }
        try {
            ImageIO.write((RenderedImage)image, "png", pathFile);
        }
        catch (IOException e) {
            throw new ImageComparisonException(String.format("Cannot save image to path=%s", pathFile.getAbsolutePath()), e);
        }
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        return ImageComparisonUtil.toBufferedImage(img.getScaledInstance(newW, newH, 4));
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        float softenFactor = 0.05f;
        Image temp = new ImageIcon(img).getImage();
        BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        return cOp.filter(bufferedImage, null);
    }

    public static float getDifferencePercent(BufferedImage img1, BufferedImage img2) {
        int width = img1.getWidth();
        int height = img1.getHeight();
        long diff = 0L;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                diff += (long)ImageComparisonUtil.pixelDiff(img1.getRGB(x, y), img2.getRGB(x, y));
            }
        }
        long maxDiff = 765L * (long)width * (long)height;
        return (float)(100.0 * (double)diff / (double)maxDiff);
    }

    public static int pixelDiff(int rgb1, int rgb2) {
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
    }
}

