/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.RuntimeType;
import com.github.maven_nar.cpptasks.SubsystemEnum;
import com.github.maven_nar.cpptasks.ide.ProjectDef;
import com.github.maven_nar.cpptasks.ide.ProjectWriterEnum;
import com.github.maven_nar.cpptasks.types.DefineArgument;
import com.github.maven_nar.cpptasks.types.DefineSet;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class NarVcprojMojo
extends AbstractCompileMojo {
    protected List getArtifacts() {
        return this.getMavenProject().getCompileArtifacts();
    }

    public void narExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.getOS().equals("Windows")) {
            this.getLog().debug((CharSequence)"Skipping -- not running on Windows");
            return;
        }
        boolean debug = false;
        List profiles = NarUtil.collectActiveProfiles(this.getMavenProject());
        for (Profile profile : profiles) {
            if (!profile.getId().equalsIgnoreCase("windows-debug")) continue;
            debug = true;
            break;
        }
        if (!debug) {
            this.getLog().info((CharSequence)"NAR: Skipping vcproj generation.  Run with -P windows-debug to enable this step.");
            return;
        }
        if (this.getLibraries().isEmpty()) {
            this.getLog().info((CharSequence)"NAR: Skipping vcproj generation.  No libraries to be built.");
            return;
        }
        this.createVcProjFile(this.getAntProject(), this.getLibraries().get(0));
    }

    private void createVcProjFile(Project antProject, Library library) throws MojoExecutionException, MojoFailureException {
        CCTask task = new CCTask();
        task.setProject(antProject);
        task.setDebug(true);
        SubsystemEnum subSystem = new SubsystemEnum();
        subSystem.setValue(library.getSubSystem());
        task.setSubsystem(subSystem);
        OutputTypeEnum outTypeEnum = new OutputTypeEnum();
        String type = library.getType();
        outTypeEnum.setValue(type);
        task.setOuttype(outTypeEnum);
        task.setLinkCPP(library.linkCPP());
        File outDir = new File(this.getTargetDirectory(), "bin");
        outDir = new File(outDir, this.getAOL().toString());
        outDir.mkdirs();
        File outFile = new File(outDir, this.getOutput(this.getAOL(), type));
        this.getLog().debug((CharSequence)("NAR - output: '" + outFile + "'"));
        task.setOutfile(outFile);
        File objDir = new File(this.getTargetDirectory(), "obj");
        objDir = new File(objDir, this.getAOL().toString());
        objDir.mkdirs();
        task.setObjdir(objDir);
        task.setFailonerror(this.failOnError(this.getAOL()));
        task.setLibtool(this.useLibtool(this.getAOL()));
        RuntimeType runtimeType = new RuntimeType();
        runtimeType.setValue(this.getRuntime(this.getAOL()));
        task.setRuntime(runtimeType);
        CompilerDef cpp = this.getCpp().getCompiler("main", null);
        if (cpp != null) {
            task.addConfiguredCompiler(cpp);
        }
        DefineSet defineSet = new DefineSet();
        DefineArgument defineArgument = new DefineArgument();
        defineArgument.setName("VCPROJ_MOJO");
        defineSet.addDefine(defineArgument);
        cpp.addConfiguredDefineset(defineSet);
        File jniDirectory = this.getJavah().getJniDirectory();
        if (jniDirectory.exists()) {
            task.createIncludePath().setPath(jniDirectory.getPath());
        }
        this.getJava().addIncludePaths(task, "executable");
        List<NarArtifact> dependencies = this.getNarArtifacts();
        for (NarArtifact narDependency : dependencies) {
            String binding = narDependency.getNarInfo().getBinding(this.getAOL(), "static");
            this.getLog().debug((CharSequence)("Looking for " + (Object)((Object)narDependency) + " found binding " + binding));
            if (binding.equals("jni")) continue;
            File unpackDirectory = this.getUnpackDirectory();
            File include = this.getLayout().getIncludeDirectory(unpackDirectory, narDependency.getArtifactId(), narDependency.getBaseVersion());
            this.getLog().debug((CharSequence)("Looking for directory: " + include));
            if (include.exists()) {
                task.createIncludePath().setPath(include.getPath());
                continue;
            }
            throw new MojoExecutionException("NAR: unable to locate include path: " + include);
        }
        LinkerDef linkerDefinition = this.getLinker().getLinker(this, antProject, this.getOS(), this.getAOL().getKey() + ".linker.", type);
        task.addConfiguredLinker(linkerDefinition);
        if (type.equals("shared") || type.equals("jni") || type.equals("executable")) {
            List depLibOrder = this.getDependencyLibOrder();
            List<NarArtifact> depLibs = dependencies;
            if (depLibOrder != null && !depLibOrder.isEmpty()) {
                LinkedList<NarArtifact> tmp = new LinkedList<NarArtifact>();
                for (String depToOrderName : depLibOrder) {
                    Iterator<NarArtifact> j = depLibs.iterator();
                    while (j.hasNext()) {
                        NarArtifact dep = j.next();
                        String depName = dep.getGroupId() + ":" + dep.getArtifactId();
                        if (!depName.equals(depToOrderName)) continue;
                        tmp.add(dep);
                        j.remove();
                    }
                }
                tmp.addAll(depLibs);
                depLibs = tmp;
            }
            for (NarArtifact dependency : depLibs) {
                String sysLibs;
                String binding = dependency.getNarInfo().getBinding(this.getAOL(), "static");
                this.getLog().debug((CharSequence)("Using Binding: " + binding));
                AOL aol = this.getAOL();
                aol = dependency.getNarInfo().getAOL(this.getAOL());
                this.getLog().debug((CharSequence)("Using Library AOL: " + aol.toString()));
                if (binding.equals("jni") || binding.equals("none") || binding.equals("executable")) continue;
                File unpackDirectory = this.getUnpackDirectory();
                File dir = this.getLayout().getLibDirectory(unpackDirectory, dependency.getArtifactId(), dependency.getBaseVersion(), aol.toString(), binding);
                this.getLog().debug((CharSequence)("Looking for Library Directory: " + dir));
                if (dir.exists()) {
                    LibrarySet libSet = new LibrarySet();
                    libSet.setProject(antProject);
                    String libs = dependency.getNarInfo().getLibs(this.getAOL());
                    if (libs != null && !libs.equals("")) {
                        this.getLog().debug((CharSequence)("Using LIBS = " + libs));
                        libSet.setLibs(new CUtil.StringArrayBuilder(libs));
                        libSet.setDir(dir);
                        task.addLibset(libSet);
                    }
                } else {
                    this.getLog().debug((CharSequence)("Library Directory " + dir + " does NOT exist."));
                }
                String options = dependency.getNarInfo().getOptions(this.getAOL());
                if (options != null && !options.equals("")) {
                    this.getLog().debug((CharSequence)("Using OPTIONS = " + options));
                    LinkerArgument arg = new LinkerArgument();
                    arg.setValue(options);
                    linkerDefinition.addConfiguredLinkerArg(arg);
                }
                if ((sysLibs = dependency.getNarInfo().getSysLibs(this.getAOL())) == null || sysLibs.equals("")) continue;
                this.getLog().debug((CharSequence)("Using SYSLIBS = " + sysLibs));
                SystemLibrarySet sysLibSet = new SystemLibrarySet();
                sysLibSet.setProject(antProject);
                sysLibSet.setLibs(new CUtil.StringArrayBuilder(sysLibs));
                task.addSyslibset(sysLibSet);
            }
            this.getJava().addRuntime(task, this.getJavaHome(this.getAOL()), this.getOS(), this.getAOL().getKey() + "java.");
            this.getLog().debug((CharSequence)"NAR: Writing project file...");
            ProjectWriterEnum projectWriterEnum = new ProjectWriterEnum();
            projectWriterEnum.setValue("msvc8");
            ProjectDef projectDef = new ProjectDef();
            projectDef.setType(projectWriterEnum);
            String filename = null;
            try {
                boolean succeeded;
                File outputDir = new File(this.getTargetDirectory(), "vcproj");
                if (!outputDir.exists() && !(succeeded = outputDir.mkdir())) {
                    throw new MojoExecutionException("Unable to create directory: " + outputDir);
                }
                filename = outputDir + "/" + this.getMavenProject().getArtifactId();
                File projFile = new File(filename);
                projectDef.setOutfile(projFile.getCanonicalFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create file: " + filename, (Exception)e);
            }
            task.addProject(projectDef);
            task.setProjectsOnly(true);
            task.setOuttype(new OutputTypeEnum());
            try {
                task.execute();
                this.getLog().info((CharSequence)("Wrote project file: " + filename + ".vcproj"));
            }
            catch (BuildException e) {
                throw new MojoExecutionException("NAR: Compile failed", (Exception)((Object)e));
            }
        }
    }
}

