/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONLiteral;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.TranslatorSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.components.AbstractJQueryTable;
import org.got5.tapestry5.jquery.internal.DataTableModel;
import org.got5.tapestry5.jquery.internal.DefaultDataTableModel;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@Import(library={"${assets.path}/components/datatables/jquery.dataTables.min.js", "${assets.path}/components/datatables/dataTables.js"}, stylesheet={"${assets.path}/components/datatables/tango/skin.css"})
public class DataTable
extends AbstractJQueryTable {
    @Inject
    private ComponentResources resources;
    @Inject
    private TypeCoercer typeCoercer;
    @Inject
    private TranslatorSource ts;
    @Environmental
    private JavaScriptSupport support;
    @Inject
    private Request request;
    @Inject
    private Messages messages;
    private DataTableModel reponse;

    public DataTable() {
        this.reponse = new DefaultDataTableModel(this.typeCoercer, this.ts);
    }

    @OnEvent(value="Data")
    JSONObject onData() {
        return this.getDataTModel().sendResponse(this.request, this.getSource(), this.getDataModel(), this.getSortModel(), this.getOverrides());
    }

    public DataTableModel getDefaultDataTableModel() {
        return this.reponse;
    }

    @AfterRender
    void setJS() {
        JSONObject setup = new JSONObject();
        setup.put("id", (Object)this.getClientId());
        JSONObject dataTableParams = new JSONObject();
        if (this.getMode().booleanValue()) {
            dataTableParams.put("sAjaxSource", (Object)this.resources.createEventLink("data", new Object[0]).toAbsoluteURI());
            dataTableParams.put("bServerSide", (Object)"true");
            dataTableParams.put("bProcessing", (Object)"true");
        }
        dataTableParams.put("sPaginationType", (Object)"full_numbers");
        dataTableParams.put("iDisplayLength", (Object)this.getRowsPerPage());
        dataTableParams.put("aLengthMenu", (Object)new JSONLiteral("[[" + this.getRowsPerPage() + "," + this.getRowsPerPage() * 2 + "," + this.getRowsPerPage() * 4 + "],[" + this.getRowsPerPage() + "," + this.getRowsPerPage() * 2 + "," + this.getRowsPerPage() * 4 + "]]"));
        JQueryUtils.merge(dataTableParams, this.getOptions());
        JSONArray sortableConfs = new JSONArray();
        for (String propertyName : this.getPropertyNames()) {
            sortableConfs.put((Object)new JSONObject(String.format("{'bSortable': %s}", this.getModel().get(propertyName).isSortable())));
        }
        dataTableParams.put("aoColumns", (Object)sortableConfs);
        JSONObject language = new JSONObject();
        language.put("sProcessing", (Object)this.messages.get("datatable.sProcessing"));
        language.put("sLengthMenu", (Object)this.messages.get("datatable.sLengthMenu"));
        language.put("sZeroRecords", (Object)this.messages.get("datatable.sZeroRecords"));
        language.put("sEmptyTable", (Object)this.messages.get("datatable.sEmptyTable"));
        language.put("sLoadingRecords", (Object)this.messages.get("datatable.sLoadingRecords"));
        language.put("sInfo", (Object)this.messages.get("datatable.sInfo"));
        language.put("sInfoEmpty", (Object)this.messages.get("datatable.sInfoEmpty"));
        language.put("sInfoFiltered", (Object)this.messages.get("datatable.sInfoFiltered"));
        language.put("sInfoPostFix", (Object)this.messages.get("datatable.sInfoPostFix"));
        language.put("sSearch", (Object)this.messages.get("datatable.sSearch"));
        language.put("sUrl", (Object)this.messages.get("datatable.sUrl"));
        dataTableParams.put("oLanguage", (Object)language);
        setup.put("params", (Object)dataTableParams);
        this.support.addInitializerCall("dataTable", setup);
    }
}

