/*
 * Decompiled with CFR 0.152.
 */
package com.github.lltyk.rhino17r1.xml.impl.xmlbeans;

import com.github.lltyk.rhino17r1.Callable;
import com.github.lltyk.rhino17r1.Context;
import com.github.lltyk.rhino17r1.Function;
import com.github.lltyk.rhino17r1.ScriptRuntime;
import com.github.lltyk.rhino17r1.Scriptable;
import com.github.lltyk.rhino17r1.Undefined;
import com.github.lltyk.rhino17r1.xml.XMLObject;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.Namespace;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.QName;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.XML;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.XMLLibImpl;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.XMLName;
import com.github.lltyk.rhino17r1.xml.impl.xmlbeans.XMLObjectImpl;
import java.util.Vector;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

class XMLList
extends XMLObjectImpl
implements Function {
    static final long serialVersionUID = -4543618751670781135L;
    private AnnotationList _annos;
    private XMLObjectImpl targetObject = null;
    private javax.xml.namespace.QName targetProperty = null;

    XMLList(XMLLibImpl lib) {
        super(lib, lib.xmlListPrototype);
        this._annos = new AnnotationList();
    }

    XMLList(XMLLibImpl lib, Object inputObject) {
        super(lib, lib.xmlListPrototype);
        if (inputObject == null || inputObject instanceof Undefined) {
            String frag = "";
        } else if (inputObject instanceof XML) {
            XML xml = (XML)inputObject;
            this._annos = new AnnotationList();
            this._annos.add(xml.getAnnotation());
        } else if (inputObject instanceof XMLList) {
            XMLList xmll = (XMLList)inputObject;
            this._annos = new AnnotationList();
            for (int i = 0; i < xmll._annos.length(); ++i) {
                this._annos.add(xmll._annos.item(i));
            }
        } else {
            String frag = ScriptRuntime.toString(inputObject).trim();
            if (!frag.startsWith("<>")) {
                frag = "<>" + frag + "</>";
            }
            if (!(frag = "<fragment>" + frag.substring(2)).endsWith("</>")) {
                throw ScriptRuntime.typeError("XML with anonymous tag missing end anonymous tag");
            }
            frag = frag.substring(0, frag.length() - 3) + "</fragment>";
            XML orgXML = XML.createFromJS(lib, frag);
            XMLList children = orgXML.children();
            this._annos = new AnnotationList();
            for (int i = 0; i < children._annos.length(); ++i) {
                this._annos.add(((XML)children.item(i).copy()).getAnnotation());
            }
        }
    }

    void setTargets(XMLObjectImpl object, javax.xml.namespace.QName property) {
        this.targetObject = object;
        this.targetProperty = property;
    }

    XML getXmlFromAnnotation(int index) {
        XML retVal;
        if (index >= 0 && index < this.length()) {
            XML.XScriptAnnotation anno = this._annos.item(index);
            retVal = XML.getFromAnnotation(this.lib, anno);
        } else {
            retVal = null;
        }
        return retVal;
    }

    private void internalRemoveFromList(int index) {
        this._annos.remove(index);
    }

    void replace(int index, XML xml) {
        if (index < this.length()) {
            int i;
            AnnotationList newAnnoList = new AnnotationList();
            for (i = 0; i < index; ++i) {
                newAnnoList.add(this._annos.item(i));
            }
            newAnnoList.add(xml.getAnnotation());
            for (i = index + 1; i < this.length(); ++i) {
                newAnnoList.add(this._annos.item(i));
            }
            this._annos = newAnnoList;
        }
    }

    private void insert(int index, XML xml) {
        if (index < this.length()) {
            int i;
            AnnotationList newAnnoList = new AnnotationList();
            for (i = 0; i < index; ++i) {
                newAnnoList.add(this._annos.item(i));
            }
            newAnnoList.add(xml.getAnnotation());
            for (i = index; i < this.length(); ++i) {
                newAnnoList.add(this._annos.item(i));
            }
            this._annos = newAnnoList;
        }
    }

    public String getClassName() {
        return "XMLList";
    }

    public Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.length()) {
            return this.getXmlFromAnnotation(index);
        }
        return Scriptable.NOT_FOUND;
    }

    boolean hasXMLProperty(XMLName xmlName) {
        boolean result = false;
        String name = xmlName.localName();
        if (this.getPropertyList(xmlName).length() > 0 || this.getMethod(name) != NOT_FOUND) {
            result = true;
        }
        return result;
    }

    public boolean has(int index, Scriptable start) {
        return 0 <= index && index < this.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void putXMLProperty(XMLName xmlName, Object value) {
        if (value == null) {
            value = "null";
        } else if (value instanceof Undefined) {
            value = "undefined";
        }
        if (this.length() > 1) {
            throw ScriptRuntime.typeError("Assignment to lists with more that one item is not supported");
        }
        if (this.length() == 0) {
            if (this.targetObject == null || this.targetProperty == null || this.targetProperty.getLocalPart().equals("*")) throw ScriptRuntime.typeError("Assignment to empty XMLList without targets not supported");
            XML xmlValue = XML.createTextElement(this.lib, this.targetProperty, "");
            this.addToList(xmlValue);
            if (xmlName.isAttributeName()) {
                this.setAttribute(xmlName, value);
            } else {
                XML xml = this.item(0);
                xml.putXMLProperty(xmlName, value);
                this.replace(0, this.item(0));
            }
            XMLName name2 = XMLName.formProperty(this.targetProperty.getNamespaceURI(), this.targetProperty.getLocalPart());
            this.targetObject.putXMLProperty(name2, this);
            return;
        } else if (xmlName.isAttributeName()) {
            this.setAttribute(xmlName, value);
            return;
        } else {
            XML xml = this.item(0);
            xml.putXMLProperty(xmlName, value);
            this.replace(0, this.item(0));
        }
    }

    Object getXMLProperty(XMLName name) {
        return this.getPropertyList(name);
    }

    public void put(int index, Scriptable start, Object value) {
        Object parent = Undefined.instance;
        if (value == null) {
            value = "null";
        } else if (value instanceof Undefined) {
            value = "undefined";
        }
        XMLObject xmlValue = value instanceof XMLObject ? (XMLObject)value : (this.targetProperty == null ? XML.createFromJS(this.lib, value.toString()) : XML.createTextElement(this.lib, this.targetProperty, value.toString()));
        parent = index < this.length() ? this.item(index).parent() : this.parent();
        if (parent instanceof XML) {
            XML xmlParent = (XML)parent;
            if (index < this.length()) {
                XMLList list;
                XML xmlNode = this.getXmlFromAnnotation(index);
                if (xmlValue instanceof XML) {
                    xmlNode.replaceAll((XML)xmlValue);
                    this.replace(index, xmlNode);
                } else if (xmlValue instanceof XMLList && (list = (XMLList)xmlValue).length() > 0) {
                    int lastIndexAdded = xmlNode.childIndex();
                    xmlNode.replaceAll(list.item(0));
                    this.replace(index, list.item(0));
                    for (int i = 1; i < list.length(); ++i) {
                        xmlParent.insertChildAfter(xmlParent.getXmlChild(lastIndexAdded), list.item(i));
                        ++lastIndexAdded;
                        this.insert(index + i, list.item(i));
                    }
                }
            } else {
                xmlParent.appendChild(xmlValue);
                this.addToList(xmlParent.getXmlChild(index));
            }
        } else if (index < this.length()) {
            XMLList list;
            XML xmlNode = XML.getFromAnnotation(this.lib, this._annos.item(index));
            if (xmlValue instanceof XML) {
                xmlNode.replaceAll((XML)xmlValue);
                this.replace(index, xmlNode);
            } else if (xmlValue instanceof XMLList && (list = (XMLList)xmlValue).length() > 0) {
                xmlNode.replaceAll(list.item(0));
                this.replace(index, list.item(0));
                for (int i = 1; i < list.length(); ++i) {
                    this.insert(index + i, list.item(i));
                }
            }
        } else {
            this.addToList(xmlValue);
        }
    }

    void deleteXMLProperty(XMLName name) {
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            if (xml.tokenType() != XmlCursor.TokenType.START) continue;
            xml.deleteXMLProperty(name);
        }
    }

    public void delete(int index) {
        if (index >= 0 && index < this.length()) {
            XML xml = this.getXmlFromAnnotation(index);
            xml.remove();
            this.internalRemoveFromList(index);
        }
    }

    public Object[] getIds() {
        Object[] enumObjs;
        if (this.prototypeFlag) {
            enumObjs = new Object[]{};
        } else {
            enumObjs = new Object[this.length()];
            for (int i = 0; i < enumObjs.length; ++i) {
                enumObjs[i] = new Integer(i);
            }
        }
        return enumObjs;
    }

    public Object[] getIdsForDebug() {
        return this.getIds();
    }

    void remove() {
        int nLen = this.length();
        for (int i = nLen - 1; i >= 0; --i) {
            XML xml = this.getXmlFromAnnotation(i);
            if (xml == null) continue;
            xml.remove();
            this.internalRemoveFromList(i);
        }
    }

    XML item(int index) {
        return this._annos != null ? this.getXmlFromAnnotation(index) : XML.createEmptyXML(this.lib);
    }

    private void setAttribute(XMLName xmlName, Object value) {
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            xml.setAttribute(xmlName, value);
        }
    }

    void addToList(Object toAdd) {
        if (toAdd instanceof Undefined) {
            return;
        }
        if (toAdd instanceof XMLList) {
            XMLList xmlSrc = (XMLList)toAdd;
            for (int i = 0; i < xmlSrc.length(); ++i) {
                this._annos.add(xmlSrc.item(i).getAnnotation());
            }
        } else if (toAdd instanceof XML) {
            this._annos.add(((XML)toAdd).getAnnotation());
        } else if (toAdd instanceof XML.XScriptAnnotation) {
            this._annos.add((XML.XScriptAnnotation)toAdd);
        }
    }

    XML addNamespace(Namespace ns) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).addNamespace(ns);
        }
        throw ScriptRuntime.typeError("The addNamespace method works only on lists containing one item");
    }

    XML appendChild(Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).appendChild(xml);
        }
        throw ScriptRuntime.typeError("The appendChild method works only on lists containing one item");
    }

    XMLList attribute(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.attribute(xmlName));
        }
        return result;
    }

    XMLList attributes() {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.attributes());
        }
        return result;
    }

    XMLList child(long index) {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            result.addToList(this.getXmlFromAnnotation(i).child(index));
        }
        return result;
    }

    XMLList child(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            result.addToList(this.getXmlFromAnnotation(i).child(xmlName));
        }
        return result;
    }

    int childIndex() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).childIndex();
        }
        throw ScriptRuntime.typeError("The childIndex method works only on lists containing one item");
    }

    XMLList children() {
        Vector<XML> v = new Vector<XML>();
        for (int i = 0; i < this.length(); ++i) {
            XMLList o;
            XML xml = this.getXmlFromAnnotation(i);
            if (xml == null || !((o = xml.children()) instanceof XMLList)) continue;
            XMLList childList = o;
            int cChildren = childList.length();
            for (int j = 0; j < cChildren; ++j) {
                v.addElement(childList.item(j));
            }
        }
        XMLList allChildren = new XMLList(this.lib);
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            allChildren.addToList(v.get(i));
        }
        return allChildren;
    }

    XMLList comments() {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.comments());
        }
        return result;
    }

    boolean contains(Object xml) {
        boolean result = false;
        for (int i = 0; i < this.length(); ++i) {
            XML member = this.getXmlFromAnnotation(i);
            if (!member.equivalentXml(xml)) continue;
            result = true;
            break;
        }
        return result;
    }

    Object copy() {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.copy());
        }
        return result;
    }

    XMLList descendants(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.descendants(xmlName));
        }
        return result;
    }

    Object[] inScopeNamespaces() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).inScopeNamespaces();
        }
        throw ScriptRuntime.typeError("The inScopeNamespaces method works only on lists containing one item");
    }

    XML insertChildAfter(Object child, Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).insertChildAfter(child, xml);
        }
        throw ScriptRuntime.typeError("The insertChildAfter method works only on lists containing one item");
    }

    XML insertChildBefore(Object child, Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).insertChildAfter(child, xml);
        }
        throw ScriptRuntime.typeError("The insertChildBefore method works only on lists containing one item");
    }

    boolean hasOwnProperty(XMLName xmlName) {
        String property;
        boolean hasProperty = false;
        hasProperty = this.prototypeFlag ? 0 != this.findPrototypeId(property = xmlName.localName()) : this.getPropertyList(xmlName).length() > 0;
        return hasProperty;
    }

    boolean hasComplexContent() {
        boolean complexContent;
        int length = this.length();
        if (length == 0) {
            complexContent = false;
        } else if (length == 1) {
            complexContent = this.getXmlFromAnnotation(0).hasComplexContent();
        } else {
            complexContent = false;
            for (int i = 0; i < length; ++i) {
                XML nextElement = this.getXmlFromAnnotation(i);
                if (nextElement.tokenType() != XmlCursor.TokenType.START) continue;
                complexContent = true;
                break;
            }
        }
        return complexContent;
    }

    boolean hasSimpleContent() {
        boolean simpleContent;
        int length = this.length();
        if (length == 0) {
            simpleContent = true;
        } else if (length == 1) {
            simpleContent = this.getXmlFromAnnotation(0).hasSimpleContent();
        } else {
            simpleContent = true;
            for (int i = 0; i < length; ++i) {
                XML nextElement = this.getXmlFromAnnotation(i);
                if (nextElement.tokenType() != XmlCursor.TokenType.START) continue;
                simpleContent = false;
                break;
            }
        }
        return simpleContent;
    }

    int length() {
        int result = 0;
        if (this._annos != null) {
            result = this._annos.length();
        }
        return result;
    }

    String localName() {
        if (this.length() == 1) {
            return this.name().localName();
        }
        throw ScriptRuntime.typeError("The localName method works only on lists containing one item");
    }

    QName name() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).name();
        }
        throw ScriptRuntime.typeError("The name method works only on lists containing one item");
    }

    Object namespace(String prefix) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).namespace(prefix);
        }
        throw ScriptRuntime.typeError("The namespace method works only on lists containing one item");
    }

    Object[] namespaceDeclarations() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).namespaceDeclarations();
        }
        throw ScriptRuntime.typeError("The namespaceDeclarations method works only on lists containing one item");
    }

    Object nodeKind() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).nodeKind();
        }
        throw ScriptRuntime.typeError("The nodeKind method works only on lists containing one item");
    }

    void normalize() {
        for (int i = 0; i < this.length(); ++i) {
            this.getXmlFromAnnotation(i).normalize();
        }
    }

    Object parent() {
        Object sameParent = Undefined.instance;
        if (this.length() == 0 && this.targetObject != null && this.targetObject instanceof XML) {
            sameParent = this.targetObject;
        } else {
            for (int i = 0; i < this.length(); ++i) {
                Object currParent = this.getXmlFromAnnotation(i).parent();
                if (i == 0) {
                    sameParent = currParent;
                    continue;
                }
                if (sameParent == currParent) continue;
                sameParent = Undefined.instance;
                break;
            }
        }
        return sameParent;
    }

    XML prependChild(Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).prependChild(xml);
        }
        throw ScriptRuntime.typeError("The prependChild method works only on lists containing one item");
    }

    Object processingInstructions(XMLName xmlName) {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xml = this.getXmlFromAnnotation(i);
            result.addToList(xml.processingInstructions(xmlName));
        }
        return result;
    }

    boolean propertyIsEnumerable(Object name) {
        long index;
        if (name instanceof Integer) {
            index = ((Integer)name).intValue();
        } else if (name instanceof Number) {
            double x = ((Number)name).doubleValue();
            index = (long)x;
            if ((double)index != x) {
                return false;
            }
            if (index == 0L && 1.0 / x < 0.0) {
                return false;
            }
        } else {
            String s = ScriptRuntime.toString(name);
            index = ScriptRuntime.testUint32String(s);
        }
        return 0L <= index && index < (long)this.length();
    }

    XML removeNamespace(Namespace ns) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).removeNamespace(ns);
        }
        throw ScriptRuntime.typeError("The removeNamespace method works only on lists containing one item");
    }

    XML replace(long index, Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).replace(index, xml);
        }
        throw ScriptRuntime.typeError("The replace method works only on lists containing one item");
    }

    XML replace(XMLName xmlName, Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).replace(xmlName, xml);
        }
        throw ScriptRuntime.typeError("The replace method works only on lists containing one item");
    }

    XML setChildren(Object xml) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).setChildren(xml);
        }
        throw ScriptRuntime.typeError("The setChildren method works only on lists containing one item");
    }

    void setLocalName(String localName) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setLocalName method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setLocalName(localName);
    }

    void setName(QName qname) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setName method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setName(qname);
    }

    void setNamespace(Namespace ns) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setNamespace method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setNamespace(ns);
    }

    XMLList text() {
        XMLList result = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            result.addToList(this.getXmlFromAnnotation(i).text());
        }
        return result;
    }

    public String toString() {
        if (this.hasSimpleContent()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.length(); ++i) {
                XML next = this.getXmlFromAnnotation(i);
                sb.append(next.toString());
            }
            return sb.toString();
        }
        return this.toXMLString(0);
    }

    String toSource(int indent) {
        return "<>" + this.toXMLString(0) + "</>";
    }

    String toXMLString(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(this.getXmlFromAnnotation(i).toXMLString(indent));
        }
        return sb.toString();
    }

    Object valueOf() {
        return this;
    }

    boolean equivalentXml(Object target) {
        XMLList otherList;
        boolean result = false;
        if (target instanceof Undefined && this.length() == 0) {
            result = true;
        } else if (this.length() == 1) {
            result = this.getXmlFromAnnotation(0).equivalentXml(target);
        } else if (target instanceof XMLList && (otherList = (XMLList)target).length() == this.length()) {
            result = true;
            for (int i = 0; i < this.length(); ++i) {
                if (this.getXmlFromAnnotation(i).equivalentXml(otherList.getXmlFromAnnotation(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private XMLList getPropertyList(XMLName name) {
        XMLList propertyList = new XMLList(this.lib);
        javax.xml.namespace.QName qname = null;
        if (!name.isDescendants() && !name.isAttributeName()) {
            qname = new javax.xml.namespace.QName(name.uri(), name.localName());
        }
        propertyList.setTargets(this, qname);
        for (int i = 0; i < this.length(); ++i) {
            propertyList.addToList(this.getXmlFromAnnotation(i).getPropertyList(name));
        }
        return propertyList;
    }

    private Object applyOrCall(boolean isApply, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String methodName;
        String string = methodName = isApply ? "apply" : "call";
        if (!(thisObj instanceof XMLList) || ((XMLList)thisObj).targetProperty == null) {
            throw ScriptRuntime.typeError1("msg.isnt.function", methodName);
        }
        return ScriptRuntime.applyOrCall(isApply, cx, scope, thisObj, args);
    }

    protected Object jsConstructor(Context cx, boolean inNewExpr, Object[] args) {
        if (args.length == 0) {
            return new XMLList(this.lib);
        }
        Object arg0 = args[0];
        if (!inNewExpr && arg0 instanceof XMLList) {
            return arg0;
        }
        return new XMLList(this.lib, arg0);
    }

    XmlObject getXmlObject() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).getXmlObject();
        }
        throw ScriptRuntime.typeError("getXmlObject method works only on lists containing one item");
    }

    public Scriptable getExtraMethodSource(Context cx) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0);
        }
        return null;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.targetProperty == null) {
            throw ScriptRuntime.notFunctionError(this);
        }
        String methodName = this.targetProperty.getLocalPart();
        boolean isApply = methodName.equals("apply");
        if (isApply || methodName.equals("call")) {
            return this.applyOrCall(isApply, cx, scope, thisObj, args);
        }
        Callable method = ScriptRuntime.getElemFunctionAndThis(this, methodName, cx);
        ScriptRuntime.lastStoredScriptable(cx);
        return method.call(cx, scope, thisObj, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeError1("msg.not.ctor", "XMLList");
    }

    static class AnnotationList {
        private Vector v = new Vector();

        AnnotationList() {
        }

        void add(XML.XScriptAnnotation n) {
            this.v.add(n);
        }

        XML.XScriptAnnotation item(int index) {
            return (XML.XScriptAnnotation)this.v.get(index);
        }

        void remove(int index) {
            this.v.remove(index);
        }

        int length() {
            return this.v.size();
        }
    }
}

