package com.github.highcharts4gwt.client.model.event;

public interface NativeEvent
{
    
    /**
     * Gets whether the ALT key was depressed when the given event occurred.
     * 
     * @return <code>true</code> if ALT was depressed when the event occurred
     */
    boolean getAltKey();

    /**
     * Gets the mouse buttons that were depressed when the given event occurred.
     * 
     * @return a bit-field, defined by {@link NativeEvent#BUTTON_LEFT},
     *         {@link NativeEvent#BUTTON_MIDDLE}, and
     *         {@link NativeEvent#BUTTON_RIGHT}
     */
    int getButton();



    /**
     * Gets the Unicode codepoint of the character generated by this key event.
     * 
     * @return the Unicode codepoint.
     */
    int getCharCode();

    /**
     * Gets the mouse x-position within the browser window's client area.
     * 
     * @return the mouse x-position
     */
    int getClientX();

    /**
     * Gets the mouse y-position within the browser window's client area.
     * 
     * @return the mouse y-position
     */
    int getClientY();

    /**
     * Gets whether the CTRL key was depressed when the given event occurred.
     * 
     * @return <code>true</code> if CTRL was depressed when the event occurred
     */
    boolean getCtrlKey();

    /**
     * Gets the key code (code associated with the physical key) associated with this event.
     * 
     * @return the key code
     * @see com.google.gwt.event.dom.client.KeyCodes
     */
    int getKeyCode();

    /**
     * Gets whether the META key was depressed when the given event occurred.
     * 
     * @return <code>true</code> if META was depressed when the event occurred
     */
    boolean getMetaKey();

    /**
     * Gets the velocity of the mouse wheel associated with the event along the Y axis.
     * <p>
     * The velocity of the event is an artifical measurement for relative comparisons of wheel activity. It is affected by some non-browser factors, including
     * choice of input hardware and mouse acceleration settings. The sign of the velocity measurement agrees with the screen coordinate system; negative values
     * are towards the origin and positive values are away from the origin. Standard scrolling speed is approximately ten units per event.
     * </p>
     * 
     * @return The velocity of the mouse wheel.
     */
    int getMouseWheelVelocityY();

    /**
     * Get the rotation in degrees, with positive values indicating clockwise rotation.
     * 
     * @return the rotation in degrees since the gesture started
     */
    double getRotation();

    /**
     * Get the amount scaled since the gesture started, with 1.0 representing no scaling.
     * 
     * @return the amount scaled since the gesture started
     */
    double getScale();

    /**
     * Gets the mouse x-position on the user's display.
     * 
     * @return the mouse x-position
     */
    int getScreenX();

    /**
     * Gets the mouse y-position on the user's display.
     * 
     * @return the mouse y-position
     */
    int getScreenY();

    /**
     * Gets whether the shift key was depressed when the given event occurred.
     * 
     * @return <code>true</code> if shift was depressed when the event occurred
     */
    boolean getShiftKey();

    /**
     * Gets a string representation of this event.
     * 
     * We do not override {@link #toString()} because it is final in {@link com.google.gwt.core.client.JavaScriptObject }.
     * 
     * @return the string representation of this event
     */
    String getString();

    /**
     * Gets the enumerated type of this event.
     * 
     * @return the event's enumerated type
     */
    String getType();

    /**
     * Prevents the browser from taking its default action for the given event.
     */
    void preventDefault();

    /**
     * Stops the event from being propagated to parent elements.
     */
    void stopPropagation();

}
