/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.ArrayList;
import java.util.List;
import smile.stat.distribution.AbstractMultivariateDistribution;
import smile.stat.distribution.MultivariateDistribution;

public class MultivariateMixture
extends AbstractMultivariateDistribution {
    List<Component> components = new ArrayList<Component>();

    MultivariateMixture() {
    }

    public MultivariateMixture(List<Component> mixture) {
        this.components.addAll(mixture);
    }

    @Override
    public double[] mean() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        double w = this.components.get((int)0).priori;
        double[] m = this.components.get((int)0).distribution.mean();
        double[] mu = new double[m.length];
        for (int i = 0; i < m.length; ++i) {
            mu[i] = w * m[i];
        }
        for (int k = 1; k < this.components.size(); ++k) {
            w = this.components.get((int)0).priori;
            m = this.components.get((int)0).distribution.mean();
            for (int i = 0; i < m.length; ++i) {
                int n = i;
                mu[n] = mu[n] + w * m[i];
            }
        }
        return mu;
    }

    @Override
    public double[][] cov() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        double w = this.components.get((int)0).priori;
        double[][] v = this.components.get((int)0).distribution.cov();
        double[][] cov = new double[v.length][v[0].length];
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                cov[i][j] = w * w * v[i][j];
            }
        }
        for (int k = 1; k < this.components.size(); ++k) {
            w = this.components.get((int)0).priori;
            v = this.components.get((int)0).distribution.cov();
            for (int i = 0; i < v.length; ++i) {
                for (int j = 0; j < v[i].length; ++j) {
                    double[] dArray = cov[i];
                    int n = j;
                    dArray[n] = dArray[n] + w * w * v[i][j];
                }
            }
        }
        return cov;
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Mixture does not support entropy()");
    }

    @Override
    public double p(double[] x) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.p(x);
        }
        return p;
    }

    @Override
    public double logp(double[] x) {
        return Math.log(this.p(x));
    }

    @Override
    public double cdf(double[] x) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.cdf(x);
        }
        return p;
    }

    @Override
    public int npara() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        int f = this.components.size() - 1;
        for (int i = 0; i < this.components.size(); ++i) {
            f += this.components.get((int)i).distribution.npara();
        }
        return f;
    }

    public int size() {
        return this.components.size();
    }

    public double bic(double[][] data) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("MultivariateMixture is empty!");
        }
        int n = data.length;
        double logLikelihood = 0.0;
        for (double[] x : data) {
            double p = this.p(x);
            if (!(p > 0.0)) continue;
            logLikelihood += Math.log(p);
        }
        return logLikelihood - 0.5 * (double)this.npara() * Math.log(n);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultivariateMixture[");
        builder.append(this.components.size());
        builder.append("]:{");
        for (Component c : this.components) {
            builder.append(" (");
            builder.append(c.distribution);
            builder.append(':');
            builder.append(String.format("%.4f", c.priori));
            builder.append(')');
        }
        builder.append("}");
        return builder.toString();
    }

    public static class Component {
        public MultivariateDistribution distribution;
        public double priori;
    }
}

