/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;

public interface Matrix {
    public int nrows();

    public int ncols();

    public Matrix transpose();

    public double get(int var1, int var2);

    default public double apply(int i, int j) {
        return this.get(i, j);
    }

    default public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    default public double trace() {
        int n = java.lang.Math.min(this.nrows(), this.ncols());
        double t = 0.0;
        for (int i = 0; i < n; ++i) {
            t += this.get(i, i);
        }
        return t;
    }

    public Matrix ata();

    public Matrix aat();

    public double[] ax(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2);

    public double[] axpy(double[] var1, double[] var2, double var3);

    public double[] atx(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2);

    public double[] atxpy(double[] var1, double[] var2, double var3);
}

