/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.RowMajorMatrix;

public class CholeskyDecomposition {
    private double[][] L;

    private CholeskyDecomposition() {
    }

    public static CholeskyDecomposition newInstance(double[][] L) {
        CholeskyDecomposition cholesky = new CholeskyDecomposition();
        cholesky.L = L;
        return cholesky;
    }

    public CholeskyDecomposition(double[][] A) {
        this(new RowMajorMatrix(A));
    }

    public CholeskyDecomposition(DenseMatrix A) {
        int n = A.nrows();
        this.L = new double[n][];
        for (int i = 0; i < n; ++i) {
            this.L[i] = new double[i + 1];
        }
        for (int j = 0; j < n; ++j) {
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (int k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A.get(j, k) - s) / this.L[k][k];
                d += s * s;
            }
            d = A.get(j, j) - d;
            if (d < 0.0) {
                throw new IllegalArgumentException("The matrix is not positive definite.");
            }
            this.L[j][j] = Math.sqrt(d);
        }
    }

    public double[][] getL() {
        return this.L;
    }

    public double det() {
        double d = 1.0;
        for (int i = 0; i < this.L.length; ++i) {
            d *= this.L[i][i];
        }
        return d * d;
    }

    public DenseMatrix inverse() {
        int n = this.L.length;
        ColumnMajorMatrix inv = ColumnMajorMatrix.eye(n);
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b) {
        this.solve(b, b);
    }

    public void solve(double[] b, double[] x) {
        int i;
        int k;
        if (b.length != this.L.length) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x 1", this.L.length, this.L.length, b.length));
        }
        if (b.length != x.length) {
            throw new IllegalArgumentException("b and x dimensions do not agree.");
        }
        int n = b.length;
        if (x != b) {
            System.arraycopy(b, 0, x, 0, n);
        }
        for (k = 0; k < n; ++k) {
            for (i = 0; i < k; ++i) {
                int n2 = k;
                x[n2] = x[n2] - x[i] * this.L[k][i];
            }
            int n3 = k;
            x[n3] = x[n3] / this.L[k][k];
        }
        for (k = n - 1; k >= 0; --k) {
            for (i = k + 1; i < n; ++i) {
                int n4 = k;
                x[n4] = x[n4] - x[i] * this.L[i][k];
            }
            int n5 = k;
            x[n5] = x[n5] / this.L[k][k];
        }
    }

    public void solve(DenseMatrix B) {
        this.solve(B, B);
    }

    public void solve(DenseMatrix B, DenseMatrix X) {
        int i;
        int k;
        int j;
        if (B.nrows() != this.L.length) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.L.length, this.L.length, B.nrows(), B.ncols()));
        }
        if (X.nrows() != B.nrows() || X.ncols() != B.ncols()) {
            throw new IllegalArgumentException("B and X dimensions do not agree.");
        }
        int n = B.nrows();
        int nx = B.ncols();
        if (X != B) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (j = 0; j < nx; ++j) {
                    X.set(i2, j, B.get(i2, j));
                }
            }
        }
        for (k = 0; k < n; ++k) {
            for (j = 0; j < nx; ++j) {
                for (i = 0; i < k; ++i) {
                    X.sub(k, j, X.get(i, j) * this.L[k][i]);
                }
                X.div(k, j, this.L[k][k]);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                for (i = k + 1; i < n; ++i) {
                    X.sub(k, j, X.get(i, j) * this.L[i][k]);
                }
                X.div(k, j, this.L[k][k]);
            }
        }
    }
}

