/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import smile.math.kernel.MercerKernel;

public class BinarySparseThinPlateSplineKernel
implements MercerKernel<int[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double sigma;

    public BinarySparseThinPlateSplineKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.sigma = sigma;
    }

    public String toString() {
        return String.format("Sparse Linear Thin Plate Spline Kernel (\u02e0 = %.4f)", this.sigma);
    }

    @Override
    public double k(int[] x, int[] y) {
        double d = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < x.length && p2 < y.length) {
            int i1 = x[p1];
            int i2 = y[p2];
            if (i1 == i2) {
                ++p1;
                ++p2;
                continue;
            }
            if (i1 > i2) {
                d += 1.0;
                ++p2;
                continue;
            }
            d += 1.0;
            ++p1;
        }
        d += (double)(x.length - p1);
        return (d += (double)(y.length - p2)) / (this.sigma * this.sigma) * Math.log(Math.sqrt(d) / this.sigma);
    }
}

