/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import smile.tensor.Matrix;
import smile.tensor.Vector;

public interface Preconditioner {
    public void solve(Vector var1, Vector var2);

    public static Preconditioner Jacobi(Matrix A) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException("Matrix A must be square");
        }
        int n = A.ncol();
        double[] diag = A.diagonal().toArray(new double[n]);
        return (b, x) -> {
            for (int i = 0; i < n; ++i) {
                double d = diag[i] != 0.0 ? b.get(i) / diag[i] : b.get(i);
                x.set(i, d);
            }
        };
    }
}

