/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import smile.io.Paths;

public record WordNet(String[] words) {
    public WordNet() throws IOException {
        this(Paths.getTestData("text/index.noun"));
    }

    public WordNet(Path path) throws IOException {
        this(WordNet.load(path));
    }

    private static String[] load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String[] stringArray = (String[])reader.lines().filter(line -> !line.startsWith(" ")).map(line -> line.split("\\s")[0].replace('_', ' ')).toArray(String[]::new);
            return stringArray;
        }
    }
}

