/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.DataFrame;
import smile.io.Paths;
import smile.io.Read;

public record BitcoinPrice(DataFrame data) {
    public BitcoinPrice() throws IOException {
        this(Paths.getTestData("timeseries/bitcoin_price.csv"));
    }

    public BitcoinPrice(Path path) throws IOException {
        this(BitcoinPrice.load(path));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setTrim(true).setHeader(new String[0]).setSkipHeaderRecord(true).get();
        return Read.csv(path, format);
    }

    public double[] price() {
        return this.data.column("Close").toDoubleArray();
    }

    public double[] logPrice() {
        double[] price = this.data.column("Close").toDoubleArray();
        for (int i = 0; i < price.length; ++i) {
            price[i] = Math.log(price[i]);
        }
        return price;
    }
}

