/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation.variogram;

import smile.interpolation.variogram.Variogram;

public class SphericalVariogram
implements Variogram {
    private final double a;
    private final double b;
    private final double c;

    public SphericalVariogram(double a, double b) {
        this(a, b, 0.0);
    }

    public SphericalVariogram(double a, double b, double c) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("Invalid parameter a = " + a);
        }
        if (b <= 0.0) {
            throw new IllegalArgumentException("Invalid parameter b = " + b);
        }
        if (c < 0.0) {
            throw new IllegalArgumentException("Invalid parameter c = " + c);
        }
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public double f(double r) {
        if (this.a <= r) {
            return this.c + this.b;
        }
        double p = r / this.a;
        return this.c + this.b * (1.5 * p - 0.5 * p * p * p);
    }

    public String toString() {
        return String.format("Spherical Variogram(range = %.4f, sill = %.4f, nugget effect = %.4f)", this.a, this.b, this.c);
    }
}

