/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import smile.data.type.DataType;

public class TimeType
implements DataType {
    static TimeType instance = new TimeType();
    private final String pattern;
    private final DateTimeFormatter formatter;

    TimeType() {
        this.pattern = "HH:mm[:ss]";
        this.formatter = DateTimeFormatter.ISO_LOCAL_TIME;
    }

    public TimeType(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public String name() {
        return String.format("Time[%s]", this.pattern);
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Time;
    }

    public String toString() {
        return "Time";
    }

    @Override
    public String toString(Object o) {
        return this.formatter.format((LocalTime)o);
    }

    @Override
    public LocalTime valueOf(String s) {
        return LocalTime.parse(s, this.formatter);
    }

    public boolean equals(Object o) {
        return o instanceof TimeType;
    }
}

