/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SparseDataset;
import smile.util.SparseArray;

class SparseDatasetImpl
implements SparseDataset {
    private static final Logger logger = LoggerFactory.getLogger(SparseDatasetImpl.class);
    private final SparseArray[] data;
    private int n;
    private final int ncol;
    private int[] colSize;

    public SparseDatasetImpl(Collection<SparseArray> data) {
        this(data, 1 + data.stream().flatMap(SparseArray::stream).mapToInt(e -> e.i).max().orElse(0));
    }

    public SparseDatasetImpl(Collection<SparseArray> data, int ncol) {
        this.data = data.toArray(new SparseArray[0]);
        this.ncol = ncol;
        this.colSize = new int[ncol];
        for (SparseArray x : data) {
            x.sort();
            int i = -1;
            for (SparseArray.Entry e : x) {
                if (e.i < 0) {
                    throw new IllegalArgumentException(String.format("Negative index of nonzero element: %d", e.i));
                }
                if (e.i == i) {
                    logger.warn(String.format("Ignore duplicated indices: %d in [%s]", e.i, x));
                    continue;
                }
                if (ncol <= e.i) {
                    ncol = e.i + 1;
                    int[] newColSize = new int[3 * ncol / 2];
                    System.arraycopy(this.colSize, 0, newColSize, 0, this.colSize.length);
                    this.colSize = newColSize;
                }
                int n = e.i;
                this.colSize[n] = this.colSize[n] + 1;
                ++this.n;
                i = e.i;
            }
        }
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public int nz() {
        return this.n;
    }

    @Override
    public int nz(int j) {
        return this.colSize[j];
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public SparseArray get(int i) {
        return this.data[i];
    }

    @Override
    public Stream<SparseArray> stream() {
        return Arrays.stream(this.data);
    }
}

