/*
 * Decompiled with CFR 0.152.
 */
package echo.output;

import echo.output.EchoOutput;
import echo.parameter.OutputLevelType;
import echo.parameter.PluginParameters;

public class EchoOutputWrapper {
    private final EchoOutput echoOutput;
    private final OutputLevelType level;

    public EchoOutputWrapper(EchoOutput echoOutput, PluginParameters pluginParameters) {
        this.echoOutput = echoOutput;
        this.level = pluginParameters.getLevel();
    }

    public void output(String content) {
        if (content.length() == 0) {
            return;
        }
        switch (this.level) {
            case FAIL: {
                this.echoOutput.fail(content);
                break;
            }
            case ERROR: {
                this.echoOutput.error(content);
                break;
            }
            case WARNING: {
                this.echoOutput.warning(content);
                break;
            }
            case INFO: {
                this.echoOutput.info(content);
                break;
            }
            case DEBUG: {
                this.echoOutput.debug(content);
            }
        }
    }
}

