/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;

public class PDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(PDFParser.class);
    private final RandomAccessBufferedFileInputStream raStream;
    private String password = "";
    private InputStream keyStoreInputStream = null;
    private String keyAlias = null;
    private AccessPermission accessPermission;
    private File tempPDFFile;

    public PDFParser(String filename) throws IOException {
        this(new File(filename), null, false);
    }

    public PDFParser(String filename, boolean useScratchFiles) throws IOException {
        this(new File(filename), null, useScratchFiles);
    }

    public PDFParser(File file) throws IOException {
        this(file, "", false);
    }

    public PDFParser(File file, boolean useScratchFiles) throws IOException {
        this(file, "", useScratchFiles);
    }

    public PDFParser(File file, String decryptionPassword) throws IOException {
        this(file, decryptionPassword, false);
    }

    public PDFParser(File file, String decryptionPassword, boolean useScratchFiles) throws IOException {
        this(file, decryptionPassword, null, null, useScratchFiles);
    }

    public PDFParser(File file, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(file, decryptionPassword, keyStore, alias, false);
    }

    public PDFParser(File file, String decryptionPassword, InputStream keyStore, String alias, boolean useScratchFiles) throws IOException {
        this.fileLen = file.length();
        this.raStream = new RandomAccessBufferedFileInputStream(file);
        this.password = decryptionPassword;
        this.keyStoreInputStream = keyStore;
        this.keyAlias = alias;
        this.init(useScratchFiles);
    }

    public PDFParser(InputStream input) throws IOException {
        this(input, "", false);
    }

    public PDFParser(InputStream input, boolean useScratchFiles) throws IOException {
        this(input, "", useScratchFiles);
    }

    public PDFParser(InputStream input, String decryptionPassword) throws IOException {
        this(input, decryptionPassword, false);
    }

    public PDFParser(InputStream input, String decryptionPassword, boolean useScratchFiles) throws IOException {
        this(input, decryptionPassword, null, null, useScratchFiles);
    }

    public PDFParser(InputStream input, String decryptionPassword, InputStream keyStore, String alias) throws IOException {
        this(input, decryptionPassword, keyStore, alias, false);
    }

    public PDFParser(InputStream input, String decryptionPassword, InputStream keyStore, String alias, boolean useScratchFiles) throws IOException {
        this.tempPDFFile = this.createTmpFile(input);
        this.fileLen = this.tempPDFFile.length();
        this.raStream = new RandomAccessBufferedFileInputStream(this.tempPDFFile);
        this.password = decryptionPassword;
        this.keyStoreInputStream = keyStore;
        this.keyAlias = alias;
        this.init(useScratchFiles);
    }

    private void init(boolean useScratchFiles) throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(useScratchFiles);
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument(), this, this.accessPermission);
    }

    protected void initialParse() throws IOException {
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        if (startXRefOffset > -1L) {
            trailer = this.parseXref(startXRefOffset);
        } else if (this.isLenient()) {
            trailer = this.rebuildTrailer();
        }
        this.prepareDecryption();
        this.parseTrailerValuesDynamically(trailer);
        COSObject catalogObj = this.document.getCatalog();
        if (catalogObj != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            this.document.setDecrypted();
        }
        this.initialParseDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parsePDFHeader() && !this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            if (!this.initialParseDone) {
                this.initialParse();
            }
            exceptionOccurred = false;
        }
        finally {
            IOUtils.closeQuietly(this.pdfSource);
            IOUtils.closeQuietly(this.keyStoreInputStream);
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }

    private void deleteTempFile() {
        if (this.tempPDFFile != null) {
            try {
                if (!this.tempPDFFile.delete()) {
                    LOG.warn((Object)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"));
                }
            }
            catch (SecurityException e) {
                LOG.warn((Object)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"), (Throwable)e);
            }
        }
    }

    private void prepareDecryption() throws IOException {
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem != null && !(trailerEncryptItem instanceof COSNull)) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseDictionaryRecursive(trailerEncryptObj);
            }
            try {
                DecryptionMaterial decryptionMaterial;
                PDEncryption encryption = new PDEncryption(this.document.getEncryptionDictionary());
                if (this.keyStoreInputStream != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(this.keyStoreInputStream, this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.keyAlias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = encryption.getSecurityHandler();
                this.securityHandler.prepareForDecryption(encryption, this.document.getDocumentID(), decryptionMaterial);
                this.accessPermission = this.securityHandler.getCurrentAccessPermission();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption", e);
            }
        }
    }

    private void parseDictionaryRecursive(COSObject dictionaryObject) throws IOException {
        this.parseObjectDynamically(dictionaryObject, true);
        COSDictionary dictionary = (COSDictionary)dictionaryObject.getObject();
        for (COSBase value : dictionary.getValues()) {
            COSObject object;
            if (!(value instanceof COSObject) || (object = (COSObject)value).getObject() != null) continue;
            this.parseDictionaryRecursive(object);
        }
    }
}

