/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.table.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import jaxx.runtime.swing.table.filter.FilterChangeListener;
import jaxx.runtime.swing.table.filter.TableFilter;
import jaxx.runtime.swing.table.filter.TableFilterState;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractTableFilter<T extends JTable>
implements TableFilter<T> {
    private final Set<FilterChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private final T table;
    private final TableFilterState filterState = new TableFilterState();
    private Map<Integer, Integer> columnDistnctIntemNumbers = new HashMap<Integer, Integer>();

    public AbstractTableFilter(T table) {
        this.table = table;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    protected abstract boolean execute(int var1, Collection<Object> var2);

    @Override
    public boolean apply(int col, Collection<Object> items) {
        this.setFilterState(col, items);
        boolean result = this.execute(col, items);
        if (result) {
            this.fireFilterChange();
        }
        return result;
    }

    @Override
    public final void addChangeListener(FilterChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeChangeListener(FilterChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public final void fireFilterChange() {
        for (FilterChangeListener l : this.listeners) {
            l.filterChanged(this);
        }
    }

    @Override
    public Collection<Object> getDistinctColumnItems(int column) {
        Collection<Object> result = this.collectDistinctColumnItems(column);
        this.columnDistnctIntemNumbers.put(column, result != null ? result.size() : 0);
        return result;
    }

    private Collection<Object> collectDistinctColumnItems(int column) {
        Set<Object> set = this.distinctValuesForColumn(column);
        ArrayList<Object> result = null;
        if (set != null) {
            result = new ArrayList<Object>(set);
            Collections.sort(result, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.NATURAL_COMPARATOR, (Transformer)new Transformer<Object, Comparable>(){

                        public Comparable transform(Object input) {
                            return AbstractTableFilter.this.toString(input);
                        }
                    }).compare(o1, o2);
                }
            });
        }
        return result;
    }

    @Override
    public Collection<Object> getFilterState(int column) {
        return this.filterState.getValues(column);
    }

    @Override
    public boolean isFiltered(int column) {
        Collection<Object> checks = this.getFilterState(column);
        return CollectionUtils.isNotEmpty(checks) && !ObjectUtils.equals((Object)this.columnDistnctIntemNumbers.get(column), (Object)checks.size());
    }

    @Override
    public boolean includeRow(TableFilter.Row row) {
        return this.filterState.include(row);
    }

    public void setFilterState(int column, Collection<Object> values) {
        this.filterState.setValues(column, values);
    }

    @Override
    public void clear() {
        this.filterState.clear();
        this.fireFilterChange();
    }
}

