/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.awt.Color;
import java.util.Scanner;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class ColorConverter
implements NuitonConverter<Color> {
    private static final Log LOGGER = LogFactory.getLog(ColorConverter.class);

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException("unsupported type: " + aClass);
        }
        String valueToString = (String)value;
        try {
            Color result;
            if (valueToString.length() == 7 && valueToString.charAt(0) == '#') {
                result = new Color(Integer.parseInt(valueToString.substring(1), 16));
            } else {
                Scanner sc = new Scanner(valueToString);
                sc.useDelimiter("\\D+");
                result = new Color(sc.nextInt(), sc.nextInt(), sc.nextInt());
            }
            return aClass.cast(result);
        }
        catch (Exception e) {
            throw new ConversionException("colors must be of the form #xxxxxx ('#' followed by six hexadecimal digits), or the name of a constant field in java.awt.Color (found: '" + valueToString + "')", (Throwable)e);
        }
    }

    @Override
    public Class<Color> getType() {
        return Color.class;
    }

    public ColorConverter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("init color converter " + this));
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return Color.class.equals(aClass);
    }
}

