/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.history;

import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.history.HistoryListUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupButton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ButtonHistory
extends AbstractToolbarPopupButton<HistoryListUI> {
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Collection histories = (Collection)evt.getNewValue();
            ButtonHistory.this.setText(ButtonHistory.this.getButtonText(histories));
        }
    };

    public ButtonHistory(DemandeUIModel model) {
        this.setToolTipText(I18n.t((String)"faxtomail.historyList.action.tip", (Object[])new Object[0]));
        this.init(model);
    }

    public String getButtonText(Collection<History> histories) {
        int replyNb = CollectionUtils.size(histories);
        return I18n.t((String)"faxtomail.historyList.text", (Object[])new Object[]{replyNb});
    }

    public void init(DemandeUIModel model) {
        if (((HistoryListUI)this.popup).getModel() != null) {
            ((HistoryListUI)this.popup).getModel().removePropertyChangeListener("history", this.listener);
        }
        ((HistoryListUI)this.popup).setModel(model);
        if (model != null) {
            ((HistoryListUI)this.popup).getModel().addPropertyChangeListener("history", this.listener);
            this.setText(this.getButtonText(model.getHistory()));
        }
    }

    @Override
    protected String getActionIcon() {
        return "view-history";
    }

    @Override
    protected HistoryListUI createNewPopup() {
        return new HistoryListUI(FaxToMailUIContext.getApplicationContext());
    }
}

